/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.ValueField;

public class MultiSelectField
extends ValueField<List<Long>> {
    public static String TYPE = "select";
    public List<SelectFieldValue> options = new LinkedList<SelectFieldValue>();
    public boolean multiselect = true;
    public boolean postOnChange;

    public MultiSelectField() {
        this(null, null, false, false);
    }

    public MultiSelectField(String id, String label, boolean editable, boolean required) {
        this(id, label, editable, null, false);
    }

    public MultiSelectField(String id, String label, boolean editable, List<Long> value, boolean required) {
        super(id, label, TYPE, editable, value, false);
    }

    private void updateSelection(SelectValue sv) {
        if (this.value == null) {
            this.value = new LinkedList();
            if (sv.selected) {
                ((List)this.value).add(sv.id);
            }
        } else {
            if (!this.multiselect && sv.selected && !((List)this.value).contains(sv.id)) {
                throw new RuntimeException("Double selected option in single select field");
            }
            sv.selected = ((List)this.value).contains(sv.id);
        }
    }

    public void add(SelectFieldValue sfv) {
        if (sfv instanceof OptionGroupValue) {
            OptionGroupValue opt = (OptionGroupValue)sfv;
            for (SelectValue sv : opt.value) {
                this.updateSelection(sv);
            }
        } else {
            this.updateSelection((SelectValue)sfv);
        }
        this.options.add(sfv);
    }

    @Override
    public boolean isValid(List<Long> valueList) {
        boolean result = false;
        if (valueList == null) {
            return false;
        }
        for (Long value : valueList) {
            block1: for (SelectFieldValue option : this.options) {
                if (option instanceof SelectValue) {
                    SelectValue sv = (SelectValue)option;
                    if (sv.id != value) continue;
                    result = true;
                    break;
                }
                OptionGroupValue og = (OptionGroupValue)option;
                for (SelectValue sv : og.value) {
                    if (sv.id != value) continue;
                    result = true;
                    continue block1;
                }
            }
            if (!result) {
                return false;
            }
            result = false;
        }
        return true;
    }

    @Override
    public void setValue(List<Long> values) {
        this.value = new LinkedList();
        if (values == null) {
            return;
        }
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                sv.selected = ((List)this.value).contains(sv.id);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.id);
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                sv.selected = values.contains(sv.id);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.id);
            }
        }
    }

    public List<String> getSelection() {
        LinkedList<String> selectedValues = new LinkedList<String>();
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                if (!sv.selected) continue;
                selectedValues.add(sv.value);
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                if (!sv.selected) continue;
                selectedValues.add(sv.value);
            }
        }
        return selectedValues;
    }
}

