/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.pkidm.servicerequest;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.ejbca.connector.pkidm.action.EJBCACertificateRequestAction;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCACertificateRequest;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCACertificateServiceRequestContent;
import org.openscdp.ejbca.connector.pkidm.signer.EJBCAProfile;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCASubject;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCATrustCenter;
import org.openscdp.pkidb.dao.RequestDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;

public class EJBCACertificateServiceRequest
extends ServiceRequestBase
implements EJBCACertificateRequest {
    public static final String PROCESS = "EJBCACertificateServiceRequest";
    private EJBCACertificateServiceRequestContent content;
    private EJBCAProfile profile;
    private EJBCASubject ejbcaSubject;
    private EJBCATrustCenter tc;

    public EJBCACertificateServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.approve")) {
            return new EJBCACertificateRequestAction(this);
        }
        return null;
    }

    @Override
    public String getEJBCAURL() {
        String url = this.getSubject().getContent().url;
        return url;
    }

    @Override
    public String getUsername() {
        return this.getContent().commonName;
    }

    @Override
    public String getSubjectDN() {
        return this.getContent().subjectDN;
    }

    @Override
    public String getCaName() {
        String dn = this.getProfile().getHolder().getName();
        X500Name xn = new X500Name(dn);
        RDN[] cn = xn.getRDNs(BCStyle.CN);
        if (cn.length != 1) {
            throw new RuntimeException("DN contains unexpected number of CN objects (#" + cn.length + ")");
        }
        ASN1Encodable value = cn[0].getFirst().getValue();
        return IETFUtils.valueToString((ASN1Encodable)value);
    }

    @Override
    public String getEmail() {
        return this.getContent().email;
    }

    @Override
    public String getSubjectAltName() {
        return this.getContent().subjectAltName;
    }

    @Override
    public String getEndEntityProfileName() {
        return this.getProfile().getContent().eepName;
    }

    @Override
    public String getCertificateProfileName() {
        return this.getProfile().getContent().cpName;
    }

    @Override
    public byte[] getPKCS10Request() {
        return this.getRequest().getBytes();
    }

    private RequestDTO getRequest() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            RequestDTO req;
            RequestDAO requestDAO = (RequestDAO)handle.attach(RequestDAO.class);
            RequestDTO requestDTO = req = requestDAO.getRequest(this.getContent().requestId);
            return requestDTO;
        }
    }

    public EJBCACertificateServiceRequestContent getContent() {
        if (this.content == null) {
            this.content = (EJBCACertificateServiceRequestContent)this.getContentView(EJBCACertificateServiceRequestContent.class);
        }
        return this.content;
    }

    private EJBCAProfile getProfile() {
        if (this.profile == null) {
            Jdbi jdbi = PKIDMContext.getJDBI();
            try (Handle handle = jdbi.open();){
                SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
                SignerDTO signer = dao.getSigner(Long.valueOf(this.getContent().signerProfileId));
                this.profile = new EJBCAProfile(signer);
            }
        }
        return this.profile;
    }

    private EJBCATrustCenter getTrustCenter() {
        if (this.tc == null) {
            Long tId = this.getRecipientId();
            this.tc = (EJBCATrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, EJBCATrustCenter.class);
        }
        return this.tc;
    }

    private EJBCASubject getSubject() {
        if (this.ejbcaSubject == null) {
            Long ejbcaSubjectId = this.getProfile().getHolder().getSubjectId();
            SubjectFactoryRegistry subFactory = PKIDMContext.getSubjectFactoryRegistry();
            this.ejbcaSubject = (EJBCASubject)subFactory.getById(ejbcaSubjectId, EJBCASubject.class);
        }
        return this.ejbcaSubject;
    }
}

