/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicore.jetty;

import de.cardcontact.opencard.web.CardSessionFactory;
import de.cardcontact.opencard.web.RemoteTerminalServlet;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkiapi.EnforceTLSFilter;
import org.openscdp.pkicard.ServiceRequestCardSessionFactory;
import org.openscdp.pkicard.TrustStoreLoader;
import org.openscdp.pkicore.jetty.CoreServletContextListener;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.cvc.importer.HSMServiceImporter;
import org.openscdp.pkihsmsrv.HSMService;
import org.openscdp.pkihsmsrv.HSMServiceEventListener;
import org.openscdp.server.jetty.BaseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher
extends BaseServer {
    private final Logger logger = LoggerFactory.getLogger(Launcher.class);

    private void configureTrustAnchors() {
        File file = new File(this.userDir + "/etc/tas");
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        TrustStoreLoader.loadTrustStore((File)file);
    }

    protected void configureContext(ServletContextHandler context) {
        context.addEventListener((EventListener)((Object)new CoreServletContextListener()));
        ServletHolder h = new ServletHolder((Servlet)new DefaultServlet());
        context.addServlet(h, "/");
        HSMService hsmService = new HSMService();
        hsmService.setEventListener((HSMServiceEventListener)new HSMServiceImporter("CORE"));
        PKIDMContext.setHSMService((HSMService)hsmService);
        RemoteTerminalServlet rts = new RemoteTerminalServlet((CardSessionFactory)hsmService);
        context.addServlet(new ServletHolder((Servlet)rts), "/rt/hsm");
        ServiceRequestCardSessionFactory srcsf = new ServiceRequestCardSessionFactory();
        rts = new RemoteTerminalServlet((CardSessionFactory)srcsf);
        context.addServlet(new ServletHolder((Servlet)rts), "/rt/core");
        EnforceTLSFilter enforceTLSFilter = new EnforceTLSFilter();
        String allowedclients = this.locateConfigItem("server.allowedclients");
        if (allowedclients != null) {
            String[] elements;
            for (String str : elements = allowedclients.split(";")) {
                enforceTLSFilter.addAuthorizedClient(new X500Principal(str));
            }
        }
        context.addFilter(new FilterHolder((Filter)enforceTLSFilter), "/api/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.openscdp.pkiapi"});
        context.addServlet(new ServletHolder((Servlet)new ServletContainer(config)), "/api/*");
        this.configureTrustAnchors();
        Jdbi jdbi = this.configureDatabase();
        context.setAttribute("JDBI", (Object)jdbi);
    }

    public static void main(String[] args) {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        SmartCardHSMProvider p = new SmartCardHSMProvider("SmartCardHSM", false);
        Security.addProvider((Provider)p);
        Launcher launcher = new Launcher();
        launcher.configPrefix = "CORE_";
        launcher.start(args);
    }
}

