/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.issuekdm;

import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.ImportDeviceCertificate;
import org.openscdp.kess.issuekdm.ImportDeviceCertificateAction;
import org.openscdp.kess.issuekdm.IssueKeyDomainMembershipForm;
import org.openscdp.kess.joingroup.JoinGroupServiceRequest;
import org.openscdp.pkicard.kdm.CreateKeyDomainAction;
import org.openscdp.pkicard.kdm.DeleteKeyDomainAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembership;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipContent;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipSharedServiceRequest;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequestContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;

public class IssueKeyDomainMembershipServiceRequest
extends IssueKeyDomainMembershipSharedServiceRequest
implements ServiceRequestForm,
ActionList,
IssueKeyDomainMembership,
ImportDeviceCertificate {
    private Form form;

    public IssueKeyDomainMembershipServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    protected List<ServiceRequestAction> getActions() {
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (this.getLifeCycle() <= 2) {
            if (!this.hasDeviceCertificate()) {
                list.add((ServiceRequestAction)new ImportDeviceCertificateAction(this));
            } else {
                list.add((ServiceRequestAction)new IssueKeyDomainMembershipAction((IssueKeyDomainMembership)this));
            }
        } else if (this.getLifeCycle() == 7 || this.getLifeCycle() == 12) {
            list.add((ServiceRequestAction)new CreateKeyDomainAction((IssueKeyDomainMembership)this));
        } else if (this.getLifeCycle() == 11) {
            list.add((ServiceRequestAction)new DeleteKeyDomainAction((IssueKeyDomainMembership)this));
        }
        return list;
    }

    public List<String> getActionList() {
        ArrayList<String> actions = new ArrayList<String>();
        List<ServiceRequestAction> list = this.getActions();
        list.forEach(e -> actions.add(e.getKeyWithContext()));
        return actions;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        List<ServiceRequestAction> list = this.getActions();
        for (ServiceRequestAction a : list) {
            if (!a.getKey().equals(action.action)) continue;
            return a;
        }
        return null;
    }

    public Form getForm() {
        if (this.form == null) {
            this.form = new IssueKeyDomainMembershipForm(this);
        }
        return this.form;
    }

    public boolean processForm(JSONAction data) {
        Form form = this.getForm();
        if (!form.setFields(data.args)) {
            return false;
        }
        this.commitForm();
        return true;
    }

    public void commitForm() {
    }

    public static IssueKeyDomainMembershipServiceRequest create(JoinGroupServiceRequest parent, HolderDTO groupMember) {
        ServiceRequestDTO dto = new ServiceRequestDTO();
        dto.setProcess("IssueKeyDomainMembership");
        dto.setTitle("Issue Key Domain Membership");
        String chr = parent.getGroupSigner().getCurrentCertificate().getCertificateHolderReference().toString();
        String tokenPath = parent.getForm().getTokenPath();
        dto.setDetails(chr + " for " + tokenPath.substring(tokenPath.lastIndexOf(47) + 1));
        dto.setState("Created");
        dto.setOriginatorId(parent.getRecipientId());
        dto.setRecipientId(parent.getTrustCenter().getId());
        dto.setAssignedToRole(parent.getTrustCenter().getCaRoleId());
        dto.setParentServiceRequestId(parent.getId());
        IssueKeyDomainMembershipContent content = new IssueKeyDomainMembershipContent();
        content.groupSignerHolderId = parent.getContent().groupSignerHolderId;
        content.tokenPath = tokenPath;
        content.groupMemberHolderId = groupMember.getId();
        IssueKeyDomainMembershipServiceRequest kdm = new IssueKeyDomainMembershipServiceRequest(dto);
        kdm.setContent((ServiceRequestContent)content);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.create(dto);
        }
        return kdm;
    }

    public IssueKeyDomainMembershipContent getContent() {
        if (this.content == null) {
            this.content = (IssueKeyDomainMembershipContent)this.getContentView(IssueKeyDomainMembershipContent.class);
        }
        return this.content;
    }
}

