/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.createescrow;

import de.cardcontact.tlv.HexString;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.createescrow.CreateEscrowKeyForm;
import org.openscdp.pkicard.escrow.create.CreateEscrowKeyContent;
import org.openscdp.pkicard.escrow.create.CreateEscrowKeySharedServiceRequest;
import org.openscdp.pkicard.escrow.create.CreateEscrowTargetKeyAction;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestContentView;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEscrowKeyServiceRequest
extends CreateEscrowKeySharedServiceRequest
implements ServiceRequestForm,
ActionList,
ServiceRequestCreationValidator {
    public static final String PROCESS = "CreateEscrowKey";
    private final Logger logger = LoggerFactory.getLogger(CreateEscrowKeyServiceRequest.class);
    private TrustCenter trustCenter;
    private CreateEscrowKeyForm form;
    private CreateEscrowKeyContent content;

    public CreateEscrowKeyServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.getRecipientId();
            this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    public boolean hasRole(Long roleId) {
        AssignedRoleDTO roleAssignment;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            RoleDAO dao = (RoleDAO)handle.attach(RoleDAO.class);
            roleAssignment = dao.getAssignedRole(this.userId.longValue(), roleId.longValue());
        }
        return roleAssignment != null;
    }

    public boolean isCAOfficer() {
        return this.hasRole(this.getTrustCenter().getCaRoleId());
    }

    public boolean validateCreation() {
        if (!this.isCAOfficer()) {
            this.dto.setState("User is not authorized");
            return false;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            Long groupSignerHolderId = this.getContent().groupSignerHolderId;
            if (groupSignerHolderId == null) {
                this.dto.setState("No group signer holder selected");
                boolean bl = false;
                return bl;
            }
            HolderDTO gsDTO = dao.getHolder(groupSignerHolderId);
            if (gsDTO == null || !gsDTO.getType().equals("GroupSigner")) {
                this.dto.setState("The group signer holder does not exist or has the wrong type");
                boolean bl = false;
                return bl;
            }
            GroupSigner gs = new GroupSigner(gsDTO);
            try {
                byte[] keyDomain = gs.getKeyDomainUID();
                this.getContent().keyDomain = HexString.hexifyByteArray((byte[])keyDomain);
            }
            catch (Exception e) {
                this.dto.setState("Invalid data");
                boolean bl = false;
                if (handle != null) {
                    handle.close();
                }
                return bl;
            }
        }
        this.dto.setTitle("Create Escrow Key");
        this.dto.setState("Created");
        this.dto.setOriginatorId(this.userId);
        this.updateContent((ServiceRequestContentView)this.getContent());
        return true;
    }

    protected List<ServiceRequestAction> getActions() {
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (!this.isCAOfficer()) {
            return list;
        }
        if (this.getLifeCycle() <= 2) {
            CreateEscrowTargetKeyAction escrowAction;
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
            if (this.getTokenPath() != null && (escrowAction = new CreateEscrowTargetKeyAction((CreateEscrowKeySharedServiceRequest)this)).preFlightCheck()) {
                list.add((ServiceRequestAction)escrowAction);
            }
        }
        return list;
    }

    public List<String> getActionList() {
        ArrayList<String> actions = new ArrayList<String>();
        List<ServiceRequestAction> list = this.getActions();
        list.forEach(e -> actions.add(e.getKeyWithContext()));
        return actions;
    }

    public Form getForm() {
        if (this.form == null) {
            this.form = new CreateEscrowKeyForm(this);
        }
        return this.form;
    }

    public boolean processForm(JSONAction data) {
        Form form = this.getForm();
        if (!form.setFields(data.args)) {
            return false;
        }
        this.commitForm();
        return true;
    }

    public void commitForm() {
        if (this.form.saveForm()) {
            if (this.getLifeCycle() == 1) {
                this.setLifeCycle(2);
                this.setRoleId(this.getTrustCenter().getCaRoleId());
            }
            this.setStatusInfo("Data saved");
            this.commit(this.userId, null);
        }
    }

    public CreateEscrowKeyContent getContent() {
        if (this.content == null) {
            this.content = (CreateEscrowKeyContent)this.getContentView(CreateEscrowKeyContent.class);
        }
        return this.content;
    }
}

