/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder.escrow;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import java.security.cert.CertificateException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkidm.holder.escrow.GroupSignerContent;
import org.openscdp.pkidm.subject.TrustCenter;

public class GroupSigner
extends CVCertificateHolder {
    public static final String TYPE = "GroupSigner";
    private TrustCenter trustCenter;
    private CVCSigner signer;
    private GroupSignerContent content;

    public GroupSigner(HolderDTO dto) {
        super(dto);
    }

    public Long getTrustCenterId() {
        return this.dto.getSubjectId();
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.dto.getSubjectId();
            this.trustCenter = PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    @Override
    public CVCSigner getSigner() {
        if (this.signer == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                CertificateDTO signerCert = this.getCurrentCertificateDTO();
                SignerDAO signerDAO = (SignerDAO)handle.attach(SignerDAO.class);
                SignerDTO signerDTO = signerDAO.getSignerByHolderAndKeyId(this.getId(), signerCert.getKeyId());
                this.signer = new CVCSigner(signerDTO);
            }
        }
        return this.signer;
    }

    public byte[] getKeyDomainUID() {
        CertificateDTO signerCert = this.getCurrentCertificateDTO();
        try {
            CardVerifiableCertificate cvc = new CardVerifiableCertificate(signerCert.getBytes());
            byte[] pk = cvc.getEncodedPublicKey();
            int len = pk.length - 1 >> 1;
            byte[] xbin = new byte[len];
            System.arraycopy(pk, 1, xbin, 0, len);
            return xbin;
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
    }

    public GroupSignerContent getContent() {
        if (this.content == null) {
            this.content = this.dto.getContent() == null ? new GroupSignerContent() : this.parseContent(GroupSignerContent.class);
        }
        return this.content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBackend() {
        if (this.getContent().backend != null) {
            return this.content.backend;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            String path = holderDAO.determinePath(this.dto.getParentId());
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO dto = dao.getToken(path);
            if (dto == null) {
                String string = null;
                return string;
            }
            if (dto.getOnline() == 0L) {
                String string = null;
                return string;
            }
            String string = dto.getLastSeenAt();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid holder in database", e);
        }
    }
}

