/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard.apdu;

import de.cardcontact.opencard.service.isocard.apdu.GeneralAuthenticateCommandAPDU;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class ChipAuthenticationResponseData
extends ConstructedTLV {
    static final Tag TAG_NONCE = new Tag(1, -128, false);
    static final Tag TAG_TOKEN = new Tag(2, -128, false);

    public ChipAuthenticationResponseData(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(GeneralAuthenticateCommandAPDU.TAG_DAD)) {
            throw new TLVEncodingException("Dynamic Authentication Data with wrong tag " + String.valueOf(tlv.getTag()));
        }
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("Dynamic Authentication Data must contain two elements");
        }
        TLV t = (TLV)this.childs.get(0);
        if (!t.getTag().equals(TAG_NONCE) || t.getLength() != 8) {
            throw new TLVEncodingException("Dynamic Authentication Data contains invalid nonce");
        }
        t = (TLV)this.childs.get(1);
        if (!t.getTag().equals(TAG_TOKEN) || t.getLength() != 8) {
            throw new TLVEncodingException("Dynamic Authentication Data contains invalid authentication token");
        }
    }

    public byte[] getNonce() {
        return ((TLV)this.childs.get(0)).getValue();
    }

    public byte[] getAuthenticationToken() {
        return ((TLV)this.childs.get(1)).getValue();
    }

    public static ChipAuthenticationResponseData parse(byte[] rsp) throws TLVEncodingException {
        TLV tlv = TLV.factory(rsp);
        return new ChipAuthenticationResponseData(tlv);
    }
}

