/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.pkcs8;

import de.cardcontact.opencard.eac.pkcs8.ECParameters;
import de.cardcontact.opencard.eac.pkcs8.ECPrivateKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.spec.ECParameterSpec;
import java.security.spec.KeySpec;

public class PrivateKeyAlgorithmIdentifier
extends Sequence {
    static final String NAME = "Private Key Algorithm Info";

    public PrivateKeyAlgorithmIdentifier(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        ObjectIdentifier oid = (ObjectIdentifier)this.childs.get(0);
        if (!oid.equals(ECParameters.ID_ECPUBLICKEY)) {
            throw new RuntimeException("Unsupported key type " + String.valueOf(oid));
        }
        this.childs.set(1, new ECParameters((TLV)this.childs.get(1)));
    }

    public KeySpec getKeySpec(byte[] encoded) throws TLVEncodingException {
        TLV tlv = TLV.factory(encoded);
        ECPrivateKeyTLV ept = new ECPrivateKeyTLV(tlv);
        ECParameterSpec spec = ((ECParameters)this.childs.get(1)).getECParameterSpec();
        return ept.getKeySpec(spec);
    }
}

