/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.sendtoescrow;

import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.sendtoescrow.SendKeyToEscrowForm;
import org.openscdp.pkicard.escrow.send.EnumerateKeysAction;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowAction;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowSharedServiceRequest;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendKeyToEscrowServiceRequest
extends SendKeyToEscrowSharedServiceRequest
implements ServiceRequestCreationValidator,
ServiceRequestForm,
ActionList {
    public static final String PROCESS = "SendKeyToEscrow";
    private final Logger logger = LoggerFactory.getLogger(SendKeyToEscrowServiceRequest.class);
    private TrustCenter trustCenter;
    private SendKeyToEscrowForm form;

    public SendKeyToEscrowServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.getRecipientId();
            this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    public Subject getSubject(Long id) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            SubjectDTO subjectDTO = dao.getSubject(id.longValue());
            Subject subject = PKIDMContext.getSubjectFactoryRegistry().getByDTO(subjectDTO);
            return subject;
        }
    }

    public boolean hasRole(Long roleId) {
        AssignedRoleDTO roleAssignment;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            RoleDAO dao = (RoleDAO)handle.attach(RoleDAO.class);
            roleAssignment = dao.getAssignedRole(this.userId.longValue(), roleId.longValue());
        }
        return roleAssignment != null;
    }

    public boolean isCAOfficer() {
        return this.hasRole(this.getTrustCenter().getCaRoleId());
    }

    public boolean isEditable() {
        if (this.getLifeCycle() >= 3) {
            return false;
        }
        String path = this.getContent().getTokenPath();
        if (path == null) {
            return true;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO token = dao.getToken(path);
            Subject subject = this.getSubject(token.getSubjectId());
            if (subject instanceof TrustCenter) {
                TrustCenter tc = (TrustCenter)subject;
                boolean bl = this.hasRole(tc.getCaRoleId());
                return bl;
            }
        }
        return true;
    }

    public SendKeyToEscrowForm getForm() {
        if (this.form == null) {
            this.form = new SendKeyToEscrowForm(this);
        }
        return this.form;
    }

    public boolean processForm(JSONAction data) {
        switch (data.action) {
            case "action.save": 
            case "action.submit": {
                SendKeyToEscrowForm form = this.getForm();
                if (!form.setFields(data.args)) {
                    return false;
                }
                this.commitForm();
            }
        }
        return true;
    }

    public void commitForm() {
        if (this.getForm().saveForm()) {
            if (this.getLifeCycle() == 1) {
                this.setLifeCycle(2);
                this.setRoleId(this.getTrustCenter().getCaRoleId());
            }
            this.setStatusInfo("Data saved");
            this.commit(this.userId, null);
        }
    }

    public boolean validateCreation() {
        this.dto.setTitle("Send Key to Escrow");
        this.dto.setState("Created");
        return true;
    }

    protected List<ServiceRequestAction> getActions() {
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (!this.isEditable()) {
            return list;
        }
        if (this.getLifeCycle() <= 2) {
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
            if (this.getContent().getTokenPath() != null) {
                list.add((ServiceRequestAction)new EnumerateKeysAction((SendKeyToEscrowSharedServiceRequest)this));
            }
            if (this.getContent().aliases != null && this.getContent().aliases.size() > 0) {
                list.add((ServiceRequestAction)new SendKeyToEscrowAction((SendKeyToEscrowSharedServiceRequest)this));
            }
        }
        return list;
    }

    public List<String> getActionList() {
        ArrayList<String> actions = new ArrayList<String>();
        List<ServiceRequestAction> list = this.getActions();
        list.forEach(e -> actions.add(e.getKeyWithContext()));
        return actions;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        List<ServiceRequestAction> list = this.getActions();
        for (ServiceRequestAction a : list) {
            if (!a.getKey().equals(action.action)) continue;
            return a;
        }
        return null;
    }
}

