/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.sendtoescrow;

import java.util.LinkedList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.sendtoescrow.SendKeyToEscrowServiceRequest;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.Binder;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.StringMultiSelectField;
import org.openscdp.pkidm.form.StringSelectField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendKeyToEscrowForm
extends Form {
    private final Logger logger = LoggerFactory.getLogger(SendKeyToEscrowForm.class);
    private SendKeyToEscrowServiceRequest sr;
    private Binder<SendKeyToEscrowContent> binder;
    private Binder.Binding<SendKeyToEscrowContent, String> tokenBinding;
    private StringMultiSelectField aliasesSelectField;

    public SendKeyToEscrowForm(SendKeyToEscrowServiceRequest sr) {
        this.sr = sr;
        this.buildForm();
    }

    public void buildForm() {
        this.binder = new Binder(SendKeyToEscrowContent.class);
        Section section = new Section();
        section.id = "token";
        section.legend = "msg.kess.sendtoescrow";
        section.fields.add(this.getTokenSelectField());
        if (this.sr.getContent().aliases != null) {
            section.fields.add(this.getAliasesSelectField());
        }
        this.sections.add(section);
        this.binder.from((Object)this.sr.getContent());
    }

    public boolean saveForm() {
        boolean hasChanged;
        SendKeyToEscrowContent content = this.sr.getContent();
        if (this.tokenBinding.hasChanged((Object)content)) {
            if (this.aliasesSelectField != null) {
                this.aliasesSelectField.setValue(new LinkedList());
            }
            content.escrowedAliases = new LinkedList();
        }
        if (hasChanged = this.binder.hasChanged((Object)content)) {
            this.binder.to((Object)content);
        }
        return hasChanged;
    }

    private StringSelectField getTokenSelectField() {
        boolean isEditable = this.sr.getLifeCycle() <= 3;
        StringSelectField fld = new StringSelectField("tokenPath", "msg.token", isEditable, true);
        fld.postOnChange = true;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            Long groupSignerHolderId = this.sr.getKeyEscrowHolder().getContent().groupSignerHolderId;
            List list = holderDAO.getHolderListBySubjectTypeAndParent(this.sr.getOriginatorId(), "GroupMember", groupSignerHolderId);
            for (HolderDTO groupMember : list) {
                fld.add((SelectFieldValue)new SelectValue(groupMember.getId().longValue(), groupMember.getName()));
            }
        }
        this.tokenBinding = this.binder.bind((HasValue)fld, SendKeyToEscrowContent::getTokenPath, SendKeyToEscrowContent::setTokenPath);
        return fld;
    }

    private StringMultiSelectField getAliasesSelectField() {
        this.aliasesSelectField = new StringMultiSelectField();
        this.aliasesSelectField.id = "aliases";
        this.aliasesSelectField.label = "msg.keys";
        if (this.sr.getContent().getAliases().size() > 0) {
            this.aliasesSelectField.editable = this.sr.isEditable();
            this.aliasesSelectField.required = true;
        }
        OptionGroupValue availableAliases = new OptionGroupValue();
        availableAliases.label = "Available for Import";
        for (String alias : this.sr.getContent().getAliases()) {
            availableAliases.value.add(new SelectValue((long)alias.hashCode(), alias));
        }
        if (availableAliases.value.size() > 0) {
            this.aliasesSelectField.add((SelectFieldValue)availableAliases);
        }
        if (this.sr.getContent().escrowedAliases != null) {
            OptionGroupValue escrowedAliases = new OptionGroupValue();
            escrowedAliases.label = "Already in Escrow";
            for (String escrowedAlias : this.sr.getContent().escrowedAliases) {
                SelectValue sv = new SelectValue((long)escrowedAlias.hashCode(), escrowedAlias);
                sv.disabled = true;
                escrowedAliases.value.add(sv);
            }
            if (escrowedAliases.value.size() > 0) {
                this.aliasesSelectField.add((SelectFieldValue)escrowedAliases);
            }
        }
        this.binder.bind((HasValue)this.aliasesSelectField, SendKeyToEscrowContent::getAliases, SendKeyToEscrowContent::setAliases);
        return this.aliasesSelectField;
    }
}

