/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.receivefromescrow;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.receivefromescrow.ReceiveKeyFromEscrowServiceRequest;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.KeyEscrowDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.KeyEscrowDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.Binder;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.MultiSelectField;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.StringSelectField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveKeyFromEscrowForm
extends Form {
    private final Logger logger = LoggerFactory.getLogger(ReceiveKeyFromEscrowForm.class);
    private ReceiveKeyFromEscrowServiceRequest sr;
    private Binder<ReceiveKeyFromEscrowContent> binder;
    private Binder.Binding<ReceiveKeyFromEscrowContent, Long> keyDomainBinding;

    public ReceiveKeyFromEscrowForm(ReceiveKeyFromEscrowServiceRequest sr) {
        this.sr = sr;
        this.buildForm();
    }

    public void buildForm() {
        this.binder = new Binder(ReceiveKeyFromEscrowContent.class);
        Section section = new Section();
        section.id = "token";
        section.legend = "msg.kess.receivefromescrow";
        section.fields.add(this.getTokenSelectField());
        if (this.sr.getLifeCycle() >= 3) {
            section.fields.add(this.getAliasesSelectField());
        }
        this.sections.add(section);
        this.binder.from((Object)this.sr.getContent());
    }

    public boolean saveForm() {
        ReceiveKeyFromEscrowContent content = this.sr.getContent();
        boolean hasChanged = this.binder.hasChanged((Object)content);
        if (hasChanged) {
            this.binder.to((Object)content);
        }
        return hasChanged;
    }

    private StringSelectField getTokenSelectField() {
        boolean isEditable = this.sr.getLifeCycle() < 3;
        StringSelectField fld = new StringSelectField("tokenPath", "msg.token", isEditable, true);
        fld.postOnChange = true;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            Long groupSignerHolderId = this.sr.getKeyEscrowHolder().getContent().groupSignerHolderId;
            List list = holderDAO.getHolderListBySubjectTypeAndParent(this.sr.getOriginatorId(), "GroupMember", groupSignerHolderId);
            for (HolderDTO groupMember : list) {
                fld.add((SelectFieldValue)new SelectValue(groupMember.getId().longValue(), groupMember.getName()));
            }
        }
        this.binder.bind((HasValue)fld, ReceiveKeyFromEscrowContent::getTokenPath, ReceiveKeyFromEscrowContent::setTokenPath);
        return fld;
    }

    private MultiSelectField getAliasesSelectField() {
        MultiSelectField fld = new MultiSelectField();
        fld.id = "keysInEscrow";
        fld.label = "msg.kess.keysInEscrow";
        fld.editable = this.sr.getLifeCycle() == 3 && this.sr.isCAOfficer();
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SignerDAO signerDAO = (SignerDAO)handle.attach(SignerDAO.class);
            KeyEscrowDAO escrowDAO = (KeyEscrowDAO)handle.attach(KeyEscrowDAO.class);
            List keyEscrowSigners = signerDAO.getSignerByHolderId(this.sr.getContent().keyEscrowHolderId);
            for (SignerDTO keyEscrowSigner : keyEscrowSigners) {
                List keysInEscrow = escrowDAO.getKeyEscrowBySigner(keyEscrowSigner.getId());
                if (keysInEscrow.size() > 0) {
                    fld.required = true;
                }
                OptionGroupValue opt = new OptionGroupValue();
                opt.label = keyEscrowSigner.getName();
                for (KeyEscrowDTO keyInEscrow : keysInEscrow) {
                    opt.value.add(new SelectValue(keyInEscrow.getId().longValue(), keyInEscrow.getName()));
                }
                fld.add((SelectFieldValue)opt);
            }
        }
        this.binder.bind((HasValue)fld, ReceiveKeyFromEscrowContent::getKeysToImport, ReceiveKeyFromEscrowContent::setKeysToImport);
        return fld;
    }
}

