/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.joingroup;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.joingroup.JoinGroupContent;
import org.openscdp.kess.joingroup.JoinGroupServiceRequest;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.Binder;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.openscdp.pkidm.subject.TrustCenter;

public class JoinGroupForm
extends Form {
    private JoinGroupServiceRequest sr;
    private Binder<JoinGroupContent> binder;
    private SelectField selectToken;

    public JoinGroupForm(JoinGroupServiceRequest sr) {
        this.sr = sr;
        this.buildForm();
    }

    public void buildForm() {
        this.binder = new Binder(JoinGroupContent.class);
        Section section = new Section();
        section.id = "token";
        section.legend = "msg.kess.join";
        section.fields.add(this.getGroupSignerField());
        section.fields.add(this.getTokenField());
        this.sections.add(section);
        this.binder.from((Object)this.sr.getContent());
    }

    public boolean saveForm() {
        JoinGroupContent content = this.sr.getContent();
        boolean hasChanged = this.binder.hasChanged((Object)content);
        if (hasChanged) {
            this.binder.to((Object)content);
        }
        return hasChanged;
    }

    private SelectField getGroupSignerField() {
        SelectField selectGroup = new SelectField();
        selectGroup.id = "selectGroup";
        selectGroup.label = "msg.kess.group";
        selectGroup.editable = this.sr.getLifeCycle() <= 2;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            SubjectDAO subjectDAO = (SubjectDAO)handle.attach(SubjectDAO.class);
            List tcList = subjectDAO.listSubjects("TrustCenter");
            for (SubjectDTO dto : tcList) {
                TrustCenter tc = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(dto.getId(), TrustCenter.class);
                if (!this.sr.hasRole(tc.getRaRoleId())) continue;
                OptionGroupValue opt = new OptionGroupValue();
                opt.label = tc.getName();
                List gsList = holderDAO.getHolderListBySubjectAndType(tc.getId(), "GroupSigner");
                for (HolderDTO gsDTO : gsList) {
                    GroupSigner gs = new GroupSigner(gsDTO);
                    String value = gs.getContent().label + " (" + gs.getName() + ")";
                    opt.value.add(new SelectValue(gs.getId().longValue(), value));
                }
                if (opt.value.size() <= 0) continue;
                selectGroup.add((SelectFieldValue)opt);
            }
            this.binder.bind((HasValue)selectGroup, JoinGroupContent::getGroupSignerHolderId, JoinGroupContent::setGroupSignerHolderId);
            SelectField selectField = selectGroup;
            return selectField;
        }
    }

    private SelectField getTokenField() {
        this.selectToken = new SelectField();
        this.selectToken.id = "selectToken";
        this.selectToken.label = "msg.token";
        this.selectToken.editable = this.sr.getLifeCycle() <= 2;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            List list = dao.getTokenList(this.sr.getRecipientId());
            this.selectToken.editable = list.size() > 1;
            for (TokenDTO token : list) {
                this.selectToken.add((SelectFieldValue)new SelectValue(token.getId().longValue(), token.getPath(), !this.selectToken.editable));
            }
        }
        this.binder.bind((HasValue)this.selectToken, JoinGroupContent::getTokenId, JoinGroupContent::setTokenId);
        return this.selectToken;
    }

    public String getTokenPath() {
        for (SelectFieldValue sfv : this.selectToken.options) {
            SelectValue sv = (SelectValue)sfv;
            if (!sv.selected) continue;
            return sv.value;
        }
        return null;
    }
}

