/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.creategroup;

import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.creategroup.CreateGroupForm;
import org.openscdp.pkicard.groupsigner.CreateGroupSharedServiceRequest;
import org.openscdp.pkicard.groupsigner.CreateGroupSignerAction;
import org.openscdp.pkicard.groupsigner.CreateSignerContent;
import org.openscdp.pkicard.groupsigner.EnumerateKeyDomains;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupServiceRequest
extends CreateGroupSharedServiceRequest
implements ServiceRequestForm,
ActionList,
ServiceRequestCreationValidator {
    public static final String PROCESS = "CreateGroup";
    private final Logger logger = LoggerFactory.getLogger(CreateGroupServiceRequest.class);
    private TrustCenter trustCenter;
    private CreateGroupForm form;
    private CreateSignerContent signerContent;

    public CreateGroupServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    protected List<ServiceRequestAction> getActions() {
        CreateGroupSignerAction gsAction;
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (!this.isCAOfficer()) {
            return list;
        }
        if (this.getLifeCycle() <= 2) {
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
        }
        if (this.getLifeCycle() == 2) {
            list.add((ServiceRequestAction)new EnumerateKeyDomains((CreateGroupSharedServiceRequest)this));
        }
        if ((this.getLifeCycle() == 2 || this.getLifeCycle() == 3) && (gsAction = new CreateGroupSignerAction((CreateGroupSharedServiceRequest)this)).preFlightCheck()) {
            list.add((ServiceRequestAction)gsAction);
        }
        return list;
    }

    public List<String> getActionList() {
        ArrayList<String> actions = new ArrayList<String>();
        List<ServiceRequestAction> list = this.getActions();
        list.forEach(e -> actions.add(e.getKeyWithContext()));
        return actions;
    }

    public CreateGroupForm getForm() {
        if (this.form == null) {
            this.form = new CreateGroupForm(this);
        }
        return this.form;
    }

    public boolean processForm(JSONAction data) {
        switch (data.action) {
            case "action.save": 
            case "action.submit": {
                CreateGroupForm form = this.getForm();
                if (!form.setFields(data.args)) {
                    return false;
                }
                this.commitForm();
            }
        }
        return true;
    }

    public void commitForm() {
        if (this.form.saveForm()) {
            if (this.getLifeCycle() == 1) {
                this.setLifeCycle(2);
                this.setRoleId(this.getTrustCenter().getCaRoleId());
            }
            this.setStatusInfo("Data saved");
            this.commit(this.userId, null);
        }
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.getRecipientId();
            this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    public boolean hasRole(Long roleId) {
        AssignedRoleDTO roleAssignment;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            RoleDAO dao = (RoleDAO)handle.attach(RoleDAO.class);
            roleAssignment = dao.getAssignedRole(this.userId.longValue(), roleId.longValue());
        }
        return roleAssignment != null;
    }

    public boolean isCAOfficer() {
        return this.hasRole(this.getTrustCenter().getCaRoleId());
    }

    public boolean validateCreation() {
        if (!this.isCAOfficer()) {
            this.dto.setState("User is not authorized");
            return false;
        }
        this.dto.setTitle("Create Group");
        this.dto.setState("Created");
        this.dto.setOriginatorId(this.userId);
        return true;
    }

    public boolean isEditable() {
        return this.getLifeCycle() <= 2;
    }

    public CreateSignerContent getContent() {
        if (this.signerContent == null) {
            this.signerContent = (CreateSignerContent)this.getContentView(CreateSignerContent.class);
        }
        return this.signerContent;
    }
}

