/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi.subject;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.util.ArrayList;
import java.util.List;
import org.openscdp.pkiapi.subject.GetTokenResponse;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetTokenListResponse {
    private final Logger logger = LoggerFactory.getLogger(GetTokenListResponse.class);
    public List<GetTokenResponse> tokenList;

    public GetTokenListResponse(List<TokenDTO> tokenList) {
        this.tokenList = new ArrayList<GetTokenResponse>(tokenList.size());
        HSMService service = PKIDMContext.getHSMService();
        for (TokenDTO token : tokenList) {
            GetTokenResponse rsp = new GetTokenResponse(token);
            SmartCardHSMProvider hsm = service.getProvider(token.getPath());
            if (hsm != null) {
                rsp.updateTokenStatus(hsm.getSmartCardHSMCardService());
            }
            this.tokenList.add(rsp);
        }
    }
}

