/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi.subject;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.LinkedList;
import java.util.List;
import opencard.core.OpenCardException;
import org.openscdp.pkiapi.subject.PKAStatus;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.json.JSONByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTokenResponse {
    private final Logger logger = LoggerFactory.getLogger(GetTokenResponse.class);
    public Long id;
    public String path;
    public String lastSeen;
    public Long serviceRequestId;
    public boolean authenticated;
    public CHVCardServiceWithControl.PasswordStatus pinStatus;
    public PKAStatus pkaStatus;
    public List<JSONByteString> keyDomains;

    public GetTokenResponse(TokenDTO token) {
        this.id = token.getId();
        this.path = token.getPath();
        this.lastSeen = token.getLastSeen().toString();
        this.serviceRequestId = token.getServiceRequestId();
    }

    public void updateTokenStatus(SmartCardHSMCardService cs) {
        try {
            this.pinStatus = cs.getPasswordStatus(null, 1);
            this.authenticated = this.pinStatus == CHVCardServiceWithControl.PasswordStatus.VERIFIED;
            this.setKeyDomains(cs);
            this.pkaStatus = PKAStatus.getStatusFromService(cs);
        }
        catch (OpenCardException e) {
            e.printStackTrace();
            throw new ServerErrorException(Response.serverError().build(), (Throwable)e);
        }
    }

    private void setKeyDomains(SmartCardHSMCardService cs) throws OpenCardException {
        this.keyDomains = new LinkedList<JSONByteString>();
        this.keyDomains.add(new JSONByteString(cs.getDefaultKeyDomainUID()));
        List kds = cs.getKeyDomains();
        for (KeyDomain kd : kds) {
            byte[] kcvOrUID = kd.getKeyDomainUID();
            if (kcvOrUID == null) {
                kcvOrUID = kd.getKcv();
            }
            if (kcvOrUID == null) {
                this.logger.debug("Skip uninitialized key domain");
                continue;
            }
            this.keyDomains.add(new JSONByteString(kcvOrUID));
        }
    }
}

