/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceTLSFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(EnforceTLSFilter.class);
    private ArrayList<X500Principal> authorizedClients = new ArrayList();

    public void addAuthorizedClient(X500Principal subject) {
        this.logger.debug("Adding " + subject + " to list of allowed clients");
        this.authorizedClients.add(subject);
    }

    private void sendError(ServletResponse response, String cause) throws IOException {
        HttpServletResponse res = (HttpServletResponse)response;
        res.sendError(403, cause);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!request.isSecure()) {
            this.sendError(response, "Must use TLS");
            return;
        }
        X509Certificate[] clientCerts = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        if (clientCerts.length < 1) {
            this.sendError(response, "No client certificate");
            return;
        }
        if (!this.authorizedClients.isEmpty()) {
            X500Principal subject = clientCerts[0].getSubjectX500Principal();
            this.logger.debug("Client authenticated as " + subject);
            if (!this.authorizedClients.contains(subject)) {
                this.sendError(response, "TLS client " + subject + " not in list of allowed clients");
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

