/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkicard.ServiceRequestCardAction;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sr")
public class ServiceRequestResource {
    private final Logger logger = LoggerFactory.getLogger(ServiceRequestResource.class);

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getServiceRequest(@PathParam(value="id") Long id) {
        ServiceRequest sr = this.loadServiceRequest(id);
        return Response.ok((Object)sr).build();
    }

    @POST
    @Path(value="/{id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postAction(@Context HttpServletRequest req, @PathParam(value="id") Long id, JSONAction action) {
        ServiceRequest sr = this.loadServiceRequest(id);
        ServiceRequestAction sra = sr.getActionFor(action);
        if (sra == null) {
            this.logger.error("Action " + action.action + " not supported for service request");
            throw new NotSupportedException();
        }
        if (sra instanceof ServiceRequestCardAction) {
            HttpSession session = req.getSession();
            session.setAttribute("ServiceRequestCardAction", (Object)sra);
        }
        return Response.ok((Object)sra.execute()).build();
    }

    @GET
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    public Response getAction(@Context HttpServletRequest req, @PathParam(value="id") Long id) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            this.logger.error("No active session for service request " + id);
            throw new NotFoundException();
        }
        ServiceRequestAction sra = (ServiceRequestAction)session.getAttribute("ServiceRequestCardAction");
        if (sra == null || !(sra instanceof ServiceRequestCardAction)) {
            this.logger.error("No active action for service request " + id);
            throw new NotFoundException();
        }
        ServiceRequestCardAction srca = (ServiceRequestCardAction)sra;
        return Response.ok((Object)srca.getStatus()).build();
    }

    private ServiceRequest loadServiceRequest(Long id) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequest sr;
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            ServiceRequestDTO dto = dao.getServiceRequest(id);
            if (dto == null) {
                this.logger.error("Service request " + id + " not found");
                throw new NotFoundException();
            }
            ServiceRequestFactoryRegistry reg = PKIDMContext.getServiceRequestFactoryRegistry();
            if (!reg.isSupported(dto)) {
                this.logger.error("Service request " + id + " not support by API");
                throw new NotSupportedException();
            }
            ServiceRequest serviceRequest = sr = reg.getByDTO(dto);
            return serviceRequest;
        }
    }
}

