/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.PKCS11LoadStoreParameter;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.PKCS11SessionStore;
import org.opensc.pkcs11.wrap.PKCS11Certificate;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11PrivateKey;
import org.opensc.util.PKCS11Id;

public class PKCS11KeyStoreSpi
extends KeyStoreSpi {
    private static final Log log = LogFactory.getLog(PKCS11KeyStoreSpi.class);
    private static final int MAX_SIMILAR_CERTIFICATES = 32;
    private final PKCS11Provider provider;
    private PKCS11SessionStore sessionStore;
    private boolean needToCloseSessionStore;
    private Map<String, PKCS11KSEntry> entries;

    public PKCS11KeyStoreSpi(PKCS11Provider pKCS11Provider, String string) {
        this.provider = pKCS11Provider;
        this.sessionStore = null;
        this.entries = null;
        this.needToCloseSessionStore = false;
        if (string != "PKCS11") {
            throw new ProviderException("Algorithm for PKCS11 KeyStore can only be \"PKCS11\".");
        }
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry == null) {
            return null;
        }
        return pKCS11KSEntry.privateKey;
    }

    private Map<String, PKCS11KSEntry> getAllCertificatesForSubject(X500Principal x500Principal) {
        HashMap<String, PKCS11KSEntry> hashMap = new HashMap<String, PKCS11KSEntry>();
        String string = x500Principal.toString();
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry != null) {
            hashMap.put(string, pKCS11KSEntry);
            int n = 1;
            do {
                String string2;
                if ((pKCS11KSEntry = this.entries.get(string2 = String.format("%s_%02X", string, ++n))) == null) continue;
                hashMap.put(string2, pKCS11KSEntry);
            } while (pKCS11KSEntry != null && n < 32);
        }
        return hashMap;
    }

    private static boolean isRootCA(X509Certificate x509Certificate) throws InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        if (!x509Certificate.getSubjectX500Principal().equals(x509Certificate.getIssuerX500Principal())) {
            return false;
        }
        x509Certificate.verify(x509Certificate.getPublicKey());
        return true;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate == null) {
            return null;
        }
        if (!(certificate instanceof X509Certificate)) {
            log.error((Object)"engineGetCertificateChain: Only X.509 certificates are supported.");
            return null;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(certificate);
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            while (!PKCS11KeyStoreSpi.isRootCA(x509Certificate)) {
                Map<String, PKCS11KSEntry> map = this.getAllCertificatesForSubject(x509Certificate.getIssuerX500Principal());
                X509Certificate x509Certificate2 = null;
                for (PKCS11KSEntry pKCS11KSEntry : map.values()) {
                    Certificate certificate2 = pKCS11KSEntry.getDecodedCertificate();
                    X509Certificate x509Certificate3 = (X509Certificate)certificate2;
                    if (!x509Certificate3.getSubjectX500Principal().equals(x509Certificate.getIssuerX500Principal())) continue;
                    try {
                        x509Certificate.verify(x509Certificate3.getPublicKey());
                        x509Certificate2 = x509Certificate3;
                        break;
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Exception during evaluation of certificate chain:", (Throwable)exception);
                    }
                }
                if (x509Certificate2 == null) break;
                x509Certificate = x509Certificate2;
                arrayList.add(x509Certificate);
            }
            return arrayList.toArray(new Certificate[0]);
        }
        catch (Exception exception) {
            log.error((Object)"Exception caught during analysis of the certificate chain:", (Throwable)exception);
            return null;
        }
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry == null) {
            return null;
        }
        try {
            return pKCS11KSEntry.getDecodedCertificate();
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)("PKCS11 Error decoding Certificate for entry " + string + ":"), (Throwable)pKCS11Exception);
        }
        catch (CertificateException certificateException) {
            log.error((Object)("Certificate Error decoding Certificate for entry " + string + ":"), (Throwable)certificateException);
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry == null) {
            return null;
        }
        return pKCS11KSEntry.creationDate;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("setKeyEntry is unimplmented.");
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("setKeyEntry is unimplmented.");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        try {
            PKCS11Certificate pKCS11Certificate = PKCS11Certificate.storeCertificate(this.sessionStore.getSession(), certificate, string, true);
            PKCS11KSEntry pKCS11KSEntry = new PKCS11KSEntry(pKCS11Certificate);
            String string2 = "ID_" + pKCS11Certificate.getId();
            PKCS11KSEntry pKCS11KSEntry2 = this.entries.get(string2);
            if (pKCS11KSEntry2 != null) {
                pKCS11KSEntry.privateKey = pKCS11KSEntry2.privateKey;
                this.entries.remove(string2);
            }
            if (string == null) {
                this.entries.put(pKCS11Certificate.getSubject().toString(), pKCS11KSEntry);
            } else {
                this.entries.put(string, pKCS11KSEntry);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyStoreException("Error encoding certificate", certificateEncodingException);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStoreException("Error storing certificate on the token", pKCS11Exception);
        }
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new KeyStoreException("deleteEntry is unimplemented.");
    }

    @Override
    public Enumeration<String> engineAliases() {
        Set<String> set = this.entries.keySet();
        Vector<String> vector = new Vector<String>(set.size());
        vector.addAll(set);
        return vector.elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string);
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry == null) {
            return false;
        }
        return pKCS11KSEntry.privateKey != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        PKCS11KSEntry pKCS11KSEntry = this.entries.get(string);
        if (pKCS11KSEntry == null) {
            return false;
        }
        return pKCS11KSEntry.certificate != null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            log.error((Object)"engineGetCertificateAlias: Only X.509 certificates are supported.");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        Map<String, PKCS11KSEntry> map = this.getAllCertificatesForSubject(x500Principal);
        for (String string : map.keySet()) {
            try {
                PKCS11KSEntry pKCS11KSEntry = map.get(string);
                if (pKCS11KSEntry.certificate == null || !pKCS11KSEntry.getDecodedCertificate().equals(certificate)) continue;
                return string;
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("PKCS11 Error decoding Certificate for entry " + string + ":"), (Throwable)pKCS11Exception);
            }
            catch (CertificateException certificateException) {
                log.error((Object)("Certificate Error decoding Certificate for entry " + string + ":"), (Throwable)certificateException);
            }
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new NoSuchAlgorithmException("PKCS11 key store does not support a store operation.");
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream != null) {
            throw new IOException("PKCS11 Key Store requires a null InputStream a the first argument.");
        }
        PKCS11LoadStoreParameter pKCS11LoadStoreParameter = new PKCS11LoadStoreParameter();
        pKCS11LoadStoreParameter.setProtectionParameter(new KeyStore.PasswordProtection(cArray));
        this.engineLoad(pKCS11LoadStoreParameter);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        String string;
        Object object;
        if (this.sessionStore != null && this.needToCloseSessionStore) {
            this.sessionStore.close();
        }
        if (loadStoreParameter instanceof PKCS11SessionStore) {
            this.sessionStore = (PKCS11SessionStore)loadStoreParameter;
            this.needToCloseSessionStore = false;
        } else {
            this.sessionStore = new PKCS11SessionStore();
            this.needToCloseSessionStore = true;
            this.sessionStore.open(this.provider, loadStoreParameter);
        }
        this.entries = new HashMap<String, PKCS11KSEntry>();
        List<PKCS11PrivateKey> list = PKCS11PrivateKey.getPrivateKeys(this.sessionStore.getSession());
        HashMap<PKCS11Id, PKCS11KSEntry> hashMap = new HashMap<PKCS11Id, PKCS11KSEntry>();
        for (PKCS11PrivateKey iterator2 : list) {
            hashMap.put(iterator2.getId(), new PKCS11KSEntry(iterator2));
        }
        List<PKCS11Certificate> list2 = PKCS11Certificate.getCertificates(this.sessionStore.getSession());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object object2 = (PKCS11Certificate)iterator.next();
            object = ((PKCS11Certificate)object2).getSubject().toString();
            string = object;
            string = object;
            int n = 1;
            while (this.entries.containsKey(string) && n < 32) {
                string = String.format("%s_%02X", object, ++n);
            }
            if (n >= 32) {
                throw new CertificateException("More than 32 instances of the same certificate subject [" + (String)object + "]found on the token.");
            }
            PKCS11KSEntry pKCS11KSEntry = new PKCS11KSEntry((PKCS11Certificate)object2);
            PKCS11KSEntry pKCS11KSEntry2 = (PKCS11KSEntry)hashMap.get(((PKCS11Object)object2).getId());
            if (pKCS11KSEntry2 != null) {
                pKCS11KSEntry.privateKey = pKCS11KSEntry2.privateKey;
                pKCS11KSEntry2.certificate = object2;
            }
            this.entries.put(string, pKCS11KSEntry);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (PKCS11KSEntry)hashMap.get(object2);
            if (((PKCS11KSEntry)object).certificate != null) continue;
            string = "ID_" + object2;
            this.entries.put(string, (PKCS11KSEntry)object);
        }
    }

    private class PKCS11KSEntry
    implements KeyStore.Entry {
        public Date creationDate = new Date();
        public PKCS11Certificate certificate;
        private Certificate decodedCertificate;
        public PKCS11PrivateKey privateKey;

        PKCS11KSEntry(PKCS11PrivateKey pKCS11PrivateKey) {
            this.privateKey = pKCS11PrivateKey;
        }

        PKCS11KSEntry(PKCS11Certificate pKCS11Certificate) {
            this.certificate = pKCS11Certificate;
        }

        public Certificate getDecodedCertificate() throws PKCS11Exception, CertificateException {
            if (this.decodedCertificate == null && this.certificate != null) {
                this.decodedCertificate = this.certificate.getCertificate();
            }
            return this.decodedCertificate;
        }
    }
}

