/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import javax.security.auth.DestroyFailedException;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11Slot;
import org.opensc.util.DestroyableHolder;
import org.opensc.util.Util;

public class PKCS11Session
extends DestroyableHolder {
    protected long pvh;
    protected long shandle;
    protected long handle;
    private boolean userLoggedIn;
    private boolean SOLoggedIn;
    public static final int OPEN_MODE_READ_ONLY = 0;
    public static final int OPEN_MODE_READ_WRITE = 1;
    private static int LOGIN_TYPE_SO = 0;
    private static int LOGIN_TYPE_USER = 1;

    protected PKCS11Session(PKCS11Slot pKCS11Slot, long l) {
        super(pKCS11Slot);
        this.pvh = pKCS11Slot.getPvh();
        this.shandle = pKCS11Slot.getHandle();
        this.handle = l;
        this.userLoggedIn = false;
        this.SOLoggedIn = false;
    }

    private static native long openNative(long var0, long var2, int var4) throws PKCS11Exception;

    private static native void closeNative(long var0, long var2, long var4);

    private static native void signInitNative(long var0, long var2, long var4, long var6, int var8, byte[] var9) throws PKCS11Exception;

    private static native void signUpdateNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native void signUpdateByteNative(long var0, long var2, long var4, byte var6) throws PKCS11Exception;

    private static native byte[] signFinalNative(long var0, long var2, long var4) throws PKCS11Exception;

    private static native byte[] signNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native void verifyInitNative(long var0, long var2, long var4, long var6, int var8, byte[] var9) throws PKCS11Exception;

    private static native void verifyUpdateNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native void verifyUpdateByteNative(long var0, long var2, long var4, byte var6) throws PKCS11Exception;

    private static native boolean verifyFinalNative(long var0, long var2, long var4, byte[] var6) throws PKCS11Exception;

    private static native boolean verifyNative(long var0, long var2, long var4, byte[] var6, int var7, int var8, byte[] var9) throws PKCS11Exception;

    private static native void encryptInitNative(long var0, long var2, long var4, long var6, int var8, byte[] var9) throws PKCS11Exception;

    private static native byte[] encryptUpdateNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native int encryptUpdateOffNative(long var0, long var2, long var4, byte[] var6, int var7, int var8, byte[] var9, int var10) throws PKCS11Exception;

    private static native byte[] encryptFinalNative(long var0, long var2, long var4) throws PKCS11Exception;

    private static native byte[] encryptNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native void decryptInitNative(long var0, long var2, long var4, long var6, int var8, byte[] var9) throws PKCS11Exception;

    private static native byte[] decryptUpdateNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native int decryptUpdateOffNative(long var0, long var2, long var4, byte[] var6, int var7, int var8, byte[] var9, int var10) throws PKCS11Exception;

    private static native byte[] decryptFinalNative(long var0, long var2, long var4) throws PKCS11Exception;

    private static native byte[] decryptNative(long var0, long var2, long var4, byte[] var6, int var7, int var8) throws PKCS11Exception;

    private static native long generateKeyNative(long var0, long var2, long var4, int var6, Object var7, PKCS11Attribute[] var8) throws PKCS11Exception;

    private static native long[] generateKeyPairNative(long var0, long var2, long var4, int var6, Object var7, PKCS11Attribute[] var8, PKCS11Attribute[] var9) throws PKCS11Exception;

    private static native byte[] wrapKeyNative(long var0, long var2, long var4, int var6, Object var7, long var8, long var10) throws PKCS11Exception;

    private static native long unwrapKeyNative(long var0, long var2, long var4, int var6, Object var7, long var8, byte[] var10, PKCS11Attribute[] var11) throws PKCS11Exception;

    private static native long deriveKeyNative(long var0, long var2, long var4, int var6, Object var7, long var8, PKCS11Attribute[] var10) throws PKCS11Exception;

    public static PKCS11Session open(PKCS11Slot pKCS11Slot, int n) throws PKCS11Exception {
        long l = PKCS11Session.openNative(pKCS11Slot.getPvh(), pKCS11Slot.getHandle(), n);
        return new PKCS11Session(pKCS11Slot, l);
    }

    private native void loginNative(long var1, long var3, long var5, int var7, byte[] var8) throws PKCS11Exception;

    public void loginUser(char[] cArray) throws PKCS11Exception {
        if (this.userLoggedIn) {
            throw new PKCS11Exception("The user is already logged in.");
        }
        this.loginNative(this.pvh, this.shandle, this.handle, LOGIN_TYPE_USER, Util.translatePin(cArray));
        this.userLoggedIn = true;
    }

    public void loginSO(char[] cArray) throws PKCS11Exception {
        if (this.SOLoggedIn) {
            throw new PKCS11Exception("The security officer is already logged in.");
        }
        this.loginNative(this.pvh, this.shandle, this.handle, LOGIN_TYPE_SO, Util.translatePin(cArray));
        this.SOLoggedIn = true;
    }

    public boolean isSOLoggedIn() {
        return this.SOLoggedIn;
    }

    public boolean isUserLoggedIn() {
        return this.userLoggedIn;
    }

    private native void logoutNative(long var1, long var3, long var5) throws PKCS11Exception;

    public void logout() throws PKCS11Exception {
        if (!this.userLoggedIn && !this.SOLoggedIn) {
            return;
        }
        this.logoutNative(this.pvh, this.shandle, this.handle);
        this.userLoggedIn = false;
        this.SOLoggedIn = false;
    }

    private native void initPINNative(long var1, long var3, long var5, byte[] var7) throws PKCS11Exception;

    public void initPIN(char[] cArray) throws PKCS11Exception {
        this.initPINNative(this.pvh, this.shandle, this.handle, Util.translatePin(cArray));
    }

    private native void setPINNative(long var1, long var3, long var5, byte[] var7, byte[] var8) throws PKCS11Exception;

    public void setPIN(char[] cArray, char[] cArray2) throws PKCS11Exception {
        this.setPINNative(this.pvh, this.shandle, this.handle, Util.translatePin(cArray), Util.translatePin(cArray2));
    }

    @Override
    public void destroy() throws DestroyFailedException {
        PKCS11Session.closeNative(this.pvh, this.shandle, this.handle);
        this.handle = 0L;
        this.shandle = 0L;
        this.pvh = 0L;
        this.userLoggedIn = false;
        this.SOLoggedIn = false;
        super.destroy();
    }

    protected long getPvh() {
        return this.pvh;
    }

    protected long getSlotHandle() {
        return this.shandle;
    }

    protected long getHandle() {
        return this.handle;
    }

    public void signInit(long l, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.signInitNative(this.pvh, this.shandle, this.handle, l, n, byArray);
    }

    public void signInit(PKCS11Object pKCS11Object, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.signInitNative(this.pvh, this.shandle, this.handle, pKCS11Object.getHandle(), n, byArray);
    }

    public void signUpdate(byte[] byArray, int n, int n2) throws PKCS11Exception {
        PKCS11Session.signUpdateNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public void signUpdate(byte by) throws PKCS11Exception {
        PKCS11Session.signUpdateByteNative(this.pvh, this.shandle, this.handle, by);
    }

    public byte[] signFinal() throws PKCS11Exception {
        return PKCS11Session.signFinalNative(this.pvh, this.shandle, this.handle);
    }

    public byte[] sign(byte[] byArray, int n, int n2) throws PKCS11Exception {
        return PKCS11Session.signNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public byte[] sign(byte[] byArray) throws PKCS11Exception {
        return this.sign(byArray, 0, byArray.length);
    }

    public void verifyInit(long l, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.verifyInitNative(this.pvh, this.shandle, this.handle, l, n, byArray);
    }

    public void verifyInit(PKCS11Object pKCS11Object, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.verifyInitNative(this.pvh, this.shandle, this.handle, pKCS11Object.getHandle(), n, byArray);
    }

    public void verifyUpdate(byte[] byArray, int n, int n2) throws PKCS11Exception {
        PKCS11Session.verifyUpdateNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public void verifyUpdate(byte by) throws PKCS11Exception {
        PKCS11Session.verifyUpdateByteNative(this.pvh, this.shandle, this.handle, by);
    }

    public boolean verifyFinal(byte[] byArray) throws PKCS11Exception {
        return PKCS11Session.verifyFinalNative(this.pvh, this.shandle, this.handle, byArray);
    }

    public boolean verify(byte[] byArray, int n, int n2, byte[] byArray2) throws PKCS11Exception {
        return PKCS11Session.verifyNative(this.pvh, this.shandle, this.handle, byArray, n, n2, byArray2);
    }

    public boolean verify(byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        return this.verify(byArray, 0, byArray.length, byArray2);
    }

    public void encryptInit(long l, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.encryptInitNative(this.pvh, this.shandle, this.handle, l, n, byArray);
    }

    public void encryptInit(PKCS11Object pKCS11Object, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.encryptInitNative(this.pvh, this.shandle, this.handle, pKCS11Object.getHandle(), n, byArray);
    }

    public byte[] encryptUpdate(byte[] byArray, int n, int n2) throws PKCS11Exception {
        return PKCS11Session.encryptUpdateNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public int encryptUpdateOff(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PKCS11Exception {
        return PKCS11Session.encryptUpdateOffNative(this.pvh, this.shandle, this.handle, byArray, n, n2, byArray2, n3);
    }

    public byte[] encryptFinal() throws PKCS11Exception {
        return PKCS11Session.encryptFinalNative(this.pvh, this.shandle, this.handle);
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) throws PKCS11Exception {
        return PKCS11Session.encryptNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public void decryptInit(long l, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.decryptInitNative(this.pvh, this.shandle, this.handle, l, n, byArray);
    }

    public void decryptInit(PKCS11Object pKCS11Object, int n, byte[] byArray) throws PKCS11Exception {
        PKCS11Session.decryptInitNative(this.pvh, this.shandle, this.handle, pKCS11Object.getHandle(), n, byArray);
    }

    public byte[] decryptUpdate(byte[] byArray, int n, int n2) throws PKCS11Exception {
        return PKCS11Session.decryptUpdateNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public int decryptUpdateOff(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PKCS11Exception {
        return PKCS11Session.decryptUpdateOffNative(this.pvh, this.shandle, this.handle, byArray, n, n2, byArray2, n3);
    }

    public byte[] decryptFinal() throws PKCS11Exception {
        return PKCS11Session.decryptFinalNative(this.pvh, this.shandle, this.handle);
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws PKCS11Exception {
        return PKCS11Session.decryptNative(this.pvh, this.shandle, this.handle, byArray, n, n2);
    }

    public long generateKey(int n, Object object, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Session.generateKeyNative(this.pvh, this.shandle, this.handle, n, object, pKCS11AttributeArray);
    }

    public long[] generateKeyPair(int n, Object object, PKCS11Attribute[] pKCS11AttributeArray, PKCS11Attribute[] pKCS11AttributeArray2) throws PKCS11Exception {
        return PKCS11Session.generateKeyPairNative(this.pvh, this.shandle, this.handle, n, object, pKCS11AttributeArray, pKCS11AttributeArray2);
    }

    public byte[] wrapKey(int n, Object object, long l, long l2) throws PKCS11Exception {
        return PKCS11Session.wrapKeyNative(this.pvh, this.shandle, this.handle, n, object, l, l2);
    }

    public byte[] wrapKey(int n, Object object, PKCS11Object pKCS11Object, PKCS11Object pKCS11Object2) throws PKCS11Exception {
        return PKCS11Session.wrapKeyNative(this.pvh, this.shandle, this.handle, n, object, pKCS11Object.getHandle(), pKCS11Object2.getHandle());
    }

    public long unwrapKey(int n, Object object, long l, byte[] byArray, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Session.unwrapKeyNative(this.pvh, this.shandle, this.handle, n, object, l, byArray, pKCS11AttributeArray);
    }

    public long unwrapKey(int n, Object object, PKCS11Object pKCS11Object, byte[] byArray, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Session.unwrapKeyNative(this.pvh, this.shandle, this.handle, n, object, pKCS11Object.getHandle(), byArray, pKCS11AttributeArray);
    }

    public long deriveKey(int n, Object object, long l, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Session.deriveKeyNative(this.pvh, this.shandle, this.handle, n, object, l, pKCS11AttributeArray);
    }

    public long deriveKey(int n, Object object, PKCS11Object pKCS11Object, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Session.deriveKeyNative(this.pvh, this.shandle, this.handle, n, object, pKCS11Object.getHandle(), pKCS11AttributeArray);
    }
}

