/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.opensc.pkcs11.spec.PKCS11PrivateKeyGenParams;
import org.opensc.pkcs11.spec.PKCS11PublicKeyGenParams;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Session;

public abstract class PKCS11KeyPairGenerator {
    protected static final int N_STATIC_PRIVATE_ATTRIBUTES = 9;
    protected static final int N_STATIC_PUBLIC_ATTRIBUTES = 4;
    private int algorithm;
    protected PKCS11Attribute[] pubKeyAttributes;
    protected PKCS11Attribute[] privKeyAttributes;

    protected PKCS11KeyPairGenerator(int n) {
        this.algorithm = n;
    }

    protected void initStaticPrivateAttrs(PKCS11PrivateKeyGenParams pKCS11PrivateKeyGenParams, int n) {
        this.privKeyAttributes = new PKCS11Attribute[9 + n];
        this.privKeyAttributes[0] = new PKCS11Attribute(264, pKCS11PrivateKeyGenParams.isSigning());
        this.privKeyAttributes[1] = new PKCS11Attribute(261, pKCS11PrivateKeyGenParams.isDecrypt());
        this.privKeyAttributes[2] = new PKCS11Attribute(263, pKCS11PrivateKeyGenParams.isUnwrap());
        this.privKeyAttributes[3] = new PKCS11Attribute(528, pKCS11PrivateKeyGenParams.isWrapWithTrusted());
        this.privKeyAttributes[4] = new PKCS11Attribute(259, pKCS11PrivateKeyGenParams.isSensitive());
        this.privKeyAttributes[5] = new PKCS11Attribute(354, pKCS11PrivateKeyGenParams.isExtractable());
        this.privKeyAttributes[6] = new PKCS11Attribute(258, pKCS11PrivateKeyGenParams.getId());
        this.privKeyAttributes[7] = new PKCS11Attribute(2, true);
        this.privKeyAttributes[8] = new PKCS11Attribute(1, true);
    }

    protected void initStaticPublicAttrs(PKCS11PublicKeyGenParams pKCS11PublicKeyGenParams, int n) {
        this.pubKeyAttributes = new PKCS11Attribute[4 + n];
        this.pubKeyAttributes[0] = new PKCS11Attribute(266, pKCS11PublicKeyGenParams.isVerify());
        this.pubKeyAttributes[1] = new PKCS11Attribute(260, pKCS11PublicKeyGenParams.isEncrypt());
        this.pubKeyAttributes[2] = new PKCS11Attribute(262, pKCS11PublicKeyGenParams.isWrap());
        this.pubKeyAttributes[3] = new PKCS11Attribute(134, pKCS11PublicKeyGenParams.isTrusted());
    }

    protected abstract PrivateKey makePrivateKey(PKCS11Session var1, long var2) throws PKCS11Exception;

    protected abstract PublicKey makePublicKey(PKCS11Session var1, long var2) throws PKCS11Exception;

    private native long[] generateKeyPairNative(long var1, long var3, long var5, int var7, PKCS11Attribute[] var8, PKCS11Attribute[] var9) throws PKCS11Exception;

    public KeyPair generateKeyPair(PKCS11Session pKCS11Session) throws PKCS11Exception {
        long[] lArray = this.generateKeyPairNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), this.algorithm, this.pubKeyAttributes, this.privKeyAttributes);
        return new KeyPair(this.makePublicKey(pKCS11Session, lArray[0]), this.makePrivateKey(pKCS11Session, lArray[1]));
    }
}

