/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.opensc.pkcs11.spec.PKCS11DSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11DSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11DSAPublicKey;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11KeyPairGenerator;
import org.opensc.pkcs11.wrap.PKCS11NeDSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11Session;

public class PKCS11DSAKeyPairGenerator
extends PKCS11KeyPairGenerator {
    private static final int N_EXTRA_PRIVATE_ATTRIBUTES = 0;
    private static final int N_EXTRA_PUBLIC_ATTRIBUTES = 3;
    private PKCS11DSAKeyPairGenParameterSpec params;

    public PKCS11DSAKeyPairGenerator(PKCS11DSAKeyPairGenParameterSpec pKCS11DSAKeyPairGenParameterSpec) {
        super(16);
        super.initStaticPublicAttrs(pKCS11DSAKeyPairGenParameterSpec, 3);
        this.pubKeyAttributes[4] = new PKCS11Attribute(304, pKCS11DSAKeyPairGenParameterSpec.getP().toByteArray());
        this.pubKeyAttributes[5] = new PKCS11Attribute(305, pKCS11DSAKeyPairGenParameterSpec.getQ().toByteArray());
        this.pubKeyAttributes[6] = new PKCS11Attribute(306, pKCS11DSAKeyPairGenParameterSpec.getG().toByteArray());
        super.initStaticPrivateAttrs(pKCS11DSAKeyPairGenParameterSpec, 0);
        this.params = pKCS11DSAKeyPairGenParameterSpec;
    }

    @Override
    protected PrivateKey makePrivateKey(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        if (this.params.isExtractable() && !this.params.isSensitive()) {
            return new PKCS11DSAPrivateKey(pKCS11Session, l);
        }
        return new PKCS11NeDSAPrivateKey(pKCS11Session, l);
    }

    @Override
    protected PublicKey makePublicKey(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        return new PKCS11DSAPublicKey(pKCS11Session, l);
    }
}

