/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.spi;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.PKCS11SessionStore;
import org.opensc.pkcs11.spec.PKCS11DSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.spec.PKCS11RSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.wrap.PKCS11DSAKeyPairGenerator;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11KeyPairGenerator;
import org.opensc.pkcs11.wrap.PKCS11RSAKeyPairGenerator;

public class PKCS11KeyPairGeneratorSpi
extends KeyPairGeneratorSpi {
    static Log log = LogFactory.getLog(PKCS11KeyPairGeneratorSpi.class);
    private PKCS11Provider provider;
    private String algorithm;
    private PKCS11SessionStore sessionStore;
    private boolean needToCloseSesionStore;
    private PKCS11KeyPairGenerator generator;

    public PKCS11KeyPairGeneratorSpi(PKCS11Provider pKCS11Provider, String string) {
        this.provider = pKCS11Provider;
        this.algorithm = string;
        this.generator = null;
        this.sessionStore = null;
        this.needToCloseSesionStore = false;
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("PKCS11KeyPairGeneratorSpi.initialize(int,SecureRandeom) is not supported.");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        KeyStore.LoadStoreParameter loadStoreParameter;
        AlgorithmParameterSpec algorithmParameterSpec2;
        if ("RSA".equals(this.algorithm)) {
            if (!(algorithmParameterSpec instanceof PKCS11RSAKeyPairGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RSA AlgorithmParameterSpec must be of type PKCS11RSAKeyPairGenParameterSpec.");
            }
            algorithmParameterSpec2 = (PKCS11RSAKeyPairGenParameterSpec)algorithmParameterSpec;
            this.generator = new PKCS11RSAKeyPairGenerator((PKCS11RSAKeyPairGenParameterSpec)algorithmParameterSpec2);
            loadStoreParameter = ((PKCS11RSAKeyPairGenParameterSpec)algorithmParameterSpec2).getLoadStoreParameter();
        } else if ("DSA".equals(this.algorithm)) {
            if (!(algorithmParameterSpec instanceof PKCS11DSAKeyPairGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DSA AlgorithmParameterSpec must be of type PKCS11DSAKeyPairGenParameterSpec.");
            }
            algorithmParameterSpec2 = (PKCS11DSAKeyPairGenParameterSpec)algorithmParameterSpec;
            this.generator = new PKCS11DSAKeyPairGenerator((PKCS11DSAKeyPairGenParameterSpec)algorithmParameterSpec2);
            loadStoreParameter = ((PKCS11DSAKeyPairGenParameterSpec)algorithmParameterSpec2).getLoadStoreParameter();
        } else {
            throw new InvalidAlgorithmParameterException("Algorithm " + this.algorithm + " is not supported.");
        }
        try {
            if (this.sessionStore != null && this.needToCloseSesionStore) {
                this.sessionStore.close();
            }
            if (loadStoreParameter instanceof PKCS11SessionStore) {
                this.sessionStore = (PKCS11SessionStore)loadStoreParameter;
                this.needToCloseSesionStore = false;
            } else {
                this.sessionStore = new PKCS11SessionStore();
                this.needToCloseSesionStore = true;
                this.sessionStore.open(this.provider, loadStoreParameter);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new RuntimeException(pKCS11Exception);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        try {
            return this.generator.generateKeyPair(this.sessionStore.getSession());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new RuntimeException(pKCS11Exception);
        }
    }
}

