/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.web;

import de.cardcontact.opencard.service.remoteclient.RemoteCardSpec;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolScript;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolUnit;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import de.cardcontact.opencard.web.CardSessionFactory;
import de.cardcontact.tlv.HexString;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommunicationErrorException;
import opencard.core.terminal.TerminalInitException;
import opencard.core.terminal.TerminalTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTerminalServlet
extends HttpServlet
implements HttpSessionListener {
    final Logger logger = LoggerFactory.getLogger(RemoteTerminalServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_CT = "cardTerminal";
    public static final String ATTRIBUTE_CSF = "cardSessionFactory";
    private static final String outboundContentType = "application/org.openscdp-content-mgt;version=1.0";
    private static final String inboundContentType = "application/org.openscdp-content-mgt-response;version=1.0";
    private static final String xAdminProtocol = "openscdp-remote-admin/1.0";

    private void closePendingSession(RemoteTerminal remoteTerminal) {
        RemoteProtocolScript rpe = new RemoteProtocolScript();
        rpe.add(new RemoteProtocolUnit(RemoteProtocolUnit.Action.CLOSE, 1, "Client reconnect"));
        remoteTerminal.put(rpe);
        try {
            int tries = 20;
            do {
                Thread.sleep(100L);
            } while (remoteTerminal.isCardPresent(0) && tries-- >= 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContentType().equals(inboundContentType)) {
            this.logger.warn("Ignoring unsupported media type " + request.getContentType());
            response.setStatus(415);
            return;
        }
        HttpSession session = request.getSession();
        String id = session.getId();
        byte[] data = this.readRemoteResponse(request);
        if (data.length == 0) {
            response.setStatus(415);
            return;
        }
        RemoteTerminal remoteTerminal = (RemoteTerminal)session.getAttribute(ATTRIBUTE_CT);
        if (remoteTerminal == null) {
            if (!RemoteProtocolScript.isInitiation((byte[])data)) {
                this.logger.debug("Ignoring message to unknown terminal " + id);
                response.setStatus(204);
                return;
            }
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null) {
                this.logger.info("Initial connect from " + userAgent + " on session " + id);
            }
            remoteTerminal = this.startSession(request, data);
        } else if (RemoteProtocolScript.isInitiation((byte[])data)) {
            this.logger.debug("Initiation message to existing terminal " + id);
            if (remoteTerminal.isCardPresent(0)) {
                this.closePendingSession(remoteTerminal);
            }
            remoteTerminal = this.startSession(request, data);
        } else {
            this.processRemoteResponse(data, remoteTerminal);
        }
        this.sendNextCommand(response, remoteTerminal, request.getRequestURI());
    }

    private RemoteTerminal startSession(HttpServletRequest request, byte[] pit) throws TerminalInitException, CardTerminalException, ServletException {
        HttpSession session = request.getSession();
        String id = session.getId();
        RemoteTerminal rt = (RemoteTerminal)session.getAttribute(ATTRIBUTE_CT);
        if (rt == null) {
            rt = new RemoteTerminal(id);
            session.setAttribute(ATTRIBUTE_CT, (Object)rt);
        }
        RemoteProtocolScript rpe = new RemoteProtocolScript();
        boolean termInitDone = false;
        try {
            rpe.decodeInitiationTemplate(pit);
            List rpus = rpe.getRemoteProtocolUnits();
            for (RemoteProtocolUnit rpu : rpus) {
                if (!rpu.isRESET()) continue;
                rt.initializeSession((RemoteCardSpec)rpu.getPayload());
                termInitDone = true;
            }
        }
        catch (Exception e) {
            this.logger.error("initializeTerminal", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        if (!termInitDone) {
            throw new ServletException("Initiation message did not contain initialization information");
        }
        this.logger.debug("Terminal instance " + id + " initialized from first protocol unit");
        CardSessionFactory csf = (CardSessionFactory)this.getServletContext().getAttribute(ATTRIBUTE_CSF);
        if (csf != null) {
            csf.newCardSession(request, rt);
        } else {
            this.logger.debug("No CardSessionFactory defined");
        }
        return rt;
    }

    private byte[] readRemoteResponse(HttpServletRequest request) throws ServletException {
        try {
            int length = request.getContentLength();
            if (length <= 0) {
                this.logger.debug("readRemoteResponse(): Nothing received");
                return new byte[0];
            }
            ServletInputStream in = request.getInputStream();
            byte[] data = new byte[length];
            for (int offset = 0; offset < length; offset += in.read(data, offset, length - offset)) {
            }
            in.close();
            this.logger.debug("readRemoteResponse(): Received " + data.length + " bytes:\n" + HexString.dump((byte[])data));
            return data;
        }
        catch (Exception e) {
            this.logger.error("readRemoteResponse", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void processRemoteResponse(byte[] data, RemoteTerminal terminal) throws ServletException {
        try {
            RemoteProtocolScript rpe = new RemoteProtocolScript();
            rpe.decodeResponseScriptingTemplate(data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(rpe.toString());
            }
            terminal.put(rpe);
        }
        catch (Exception e) {
            this.logger.error("processRemoteResponse", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void sendNextCommand(HttpServletResponse response, RemoteTerminal terminal, String uri) throws ServletException {
        try {
            response.addHeader("X-Admin-Protocol", xAdminProtocol);
            response.addHeader("X-Admin-Next-URI", uri);
            this.logger.debug("Starting to poll");
            RemoteProtocolScript rpe = terminal.poll(30);
            if (rpe == null) {
                this.logger.debug("Polling timeout");
                rpe = new RemoteProtocolScript();
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received from server process\n" + rpe.toString());
                }
                if (rpe.isClosing()) {
                    this.logger.debug("Terminal closing (204).");
                    response.setStatus(204);
                    return;
                }
            }
            response.setContentType(outboundContentType);
            ServletOutputStream out = response.getOutputStream();
            byte[] respdata = rpe.encodeCommandScriptingTemplate();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending command scripting template\n" + HexString.dump((byte[])respdata));
            }
            out.write(respdata);
            out.close();
            response.setStatus(200);
        }
        catch (TerminalTimeoutException e) {
            this.logger.debug("Terminal process died unexpectedly", (Throwable)e);
            response.setStatus(408);
        }
        catch (CommunicationErrorException e) {
            this.logger.debug("Timeout waiting for first APDU from server process", (Throwable)e);
            response.setStatus(504);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        String id = session.getId();
        this.logger.debug("Session " + id + " destroyed");
        RemoteTerminal rt = (RemoteTerminal)session.getAttribute(ATTRIBUTE_CT);
        if (rt != null) {
            try {
                rt.close();
            }
            catch (CardTerminalException cardTerminalException) {
                // empty catch block
            }
        }
    }
}

