/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.ui.smartcardhsm;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ChangeReferenceDataDialog {
    private int pinLength = 6;
    static ResourceBundle rb = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());
    private String title = rb.getString("chvmanagement.title");
    private String lowRetryCounterStatus = rb.getString("status.lowRetryCounter");
    private String lastTryStatus = rb.getString("status.lastTry");
    private String blockedStatus = rb.getString("status.blocked");
    private String transportStatus = rb.getString("status.transport");
    private String wrongPINStatus = rb.getString("chvmanagement.error.wrongPin");
    private JLabel currentPINMsg = new JLabel(rb.getString("chvmanagement.pin"));
    private JLabel newPINMsg = new JLabel(rb.getString("chvmanagement.newPin"));
    private JLabel newPINConfirmationMsg = new JLabel(rb.getString("chvmanagement.confirmPin"));
    private JLabel txtStatus = new JLabel();
    private JPanel currentPINField;
    private JPanel newPINField;
    private JPanel pinConfirmationField;
    private JPanel newPINFields;
    private JPasswordField currentPIN = new JPasswordField(this.pinLength);
    private JPasswordField newPIN = new JPasswordField(this.pinLength);
    private JPasswordField newPINConfirmation = new JPasswordField(this.pinLength);
    private CHVCardServiceWithControl.PasswordStatus passwordStatus;
    private JOptionPane optionPane;
    private JDialog dialog;
    private boolean validInput = false;

    private void createDialog() {
        this.txtStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.currentPINMsg.setBorder(new EmptyBorder(0, 0, 0, 6));
        this.newPINMsg.setBorder(new EmptyBorder(0, 0, 0, 6));
        this.newPINConfirmationMsg.setBorder(new EmptyBorder(0, 0, 0, 6));
        this.currentPINField = new JPanel();
        this.currentPINField.setLayout(new GridLayout(0, 2));
        this.currentPINField.add(this.currentPINMsg);
        this.currentPINField.add(this.currentPIN);
        this.newPINField = new JPanel();
        this.newPINField.setLayout(new GridLayout(0, 2));
        this.newPINField.add(this.newPINMsg);
        this.newPINField.add(this.newPIN);
        this.pinConfirmationField = new JPanel();
        this.pinConfirmationField.setLayout(new GridLayout(0, 2));
        this.pinConfirmationField.add(this.newPINConfirmationMsg);
        this.pinConfirmationField.add(this.newPINConfirmation);
        this.newPINFields = new JPanel();
        this.newPINFields.setLayout(new BoxLayout(this.newPINFields, 3));
        this.newPINFields.add(this.newPINField);
        this.newPINFields.add(this.pinConfirmationField);
        JComponent[] input = new JComponent[]{this.txtStatus, this.currentPINField, this.newPINFields};
        int messageType = -1;
        int optionType = 2;
        String[] options = null;
        if (this.passwordStatus == CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED) {
            this.addErrorMessage(this.currentPINField, this.wrongPINStatus);
        } else if (this.passwordStatus == CHVCardServiceWithControl.PasswordStatus.RETRYCOUNTERLOW) {
            this.txtStatus.setText(this.lowRetryCounterStatus);
            messageType = 2;
        } else if (this.passwordStatus == CHVCardServiceWithControl.PasswordStatus.LASTTRY) {
            this.txtStatus.setText(this.lastTryStatus);
            messageType = 2;
        } else if (this.passwordStatus == CHVCardServiceWithControl.PasswordStatus.BLOCKED) {
            this.txtStatus.setText(this.blockedStatus);
            input = new JComponent[]{this.txtStatus};
            messageType = 0;
            optionType = -1;
            options = new String[]{"OK"};
        } else if (this.passwordStatus == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE) {
            this.txtStatus.setText(this.transportStatus);
        }
        this.optionPane = new JOptionPane(input, messageType, optionType, null, options, null);
        this.dialog = this.optionPane.createDialog(this.title);
        this.focusCurrentPIN();
    }

    private void focusCurrentPIN() {
        this.dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ChangeReferenceDataDialog.this.currentPIN.requestFocusInWindow();
            }
        });
    }

    private void focusNewPIN() {
        this.dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ChangeReferenceDataDialog.this.newPIN.requestFocusInWindow();
            }
        });
    }

    private void focusConfirmationPIN() {
        this.dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ChangeReferenceDataDialog.this.newPINConfirmation.requestFocusInWindow();
            }
        });
    }

    public boolean showDialog() {
        this.createDialog();
        this.validInput = false;
        while (!this.validInput) {
            this.dialog.setAlwaysOnTop(true);
            this.dialog.setVisible(true);
            Object action = this.optionPane.getValue();
            if (action != null && (Integer)action == 0) {
                this.validate();
                continue;
            }
            if (action == null || (Integer)action != 2) continue;
            this.currentPIN.setText("");
            this.newPIN.setText("");
            this.newPINConfirmation.setText("");
            return false;
        }
        return true;
    }

    private void validate() {
        if (this.currentPIN.getPassword().length == 0) {
            this.createDialog();
            this.addErrorMessage(this.currentPINField, rb.getString("chvmanagement.error.noPin"));
            return;
        }
        if (this.newPIN.getPassword().length == 0) {
            this.createDialog();
            this.focusNewPIN();
            this.addErrorMessage(this.newPINField, rb.getString("chvmanagement.error.noNewPin"));
            return;
        }
        if (this.newPINConfirmation.getPassword().length == 0) {
            this.createDialog();
            this.focusConfirmationPIN();
            this.addErrorMessage(this.pinConfirmationField, rb.getString("chvmanagement.error.noConfirmPin"));
            return;
        }
        if (!Arrays.equals(this.newPIN.getPassword(), this.newPINConfirmation.getPassword())) {
            this.newPIN.setText("");
            this.newPINConfirmation.setText("");
            this.createDialog();
            this.focusNewPIN();
            this.addErrorMessage(this.newPINFields, rb.getString("chvmanagement.error.confirmationFailed"));
            return;
        }
        this.validInput = true;
    }

    public void setPasswordStatus(CHVCardServiceWithControl.PasswordStatus status) {
        this.passwordStatus = status;
    }

    private void addErrorMessage(JPanel panel, String msg) {
        JLabel error = new JLabel(msg);
        error.setForeground(Color.RED);
        panel.add(error);
        Border outsideBorder = BorderFactory.createLineBorder(Color.RED);
        Border insideBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        panel.setBorder(border);
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    public byte[] getCurrentPIN() {
        byte[] pin = this.toByteArray(this.currentPIN.getPassword());
        this.currentPIN.setText("000000");
        this.currentPIN.setText("");
        return pin;
    }

    public byte[] getNewPIN() {
        byte[] pin = this.toByteArray(this.newPIN.getPassword());
        this.newPIN.setText("000000");
        this.newPIN.setText("");
        this.newPINConfirmation.setText("000000");
        this.newPINConfirmation.setText("");
        return pin;
    }

    private byte[] toByteArray(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

