/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.ui.smartcardhsm;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.CHVManager;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.ui.smartcardhsm.ChangeReferenceDataDialog;
import de.cardcontact.opencard.ui.smartcardhsm.SmartCardHSMCHVDialog;
import opencard.core.service.CHVUtils;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;

public class DefaultCHVManager
implements CHVManager {
    private SmartCardHSMCardService service;
    private ChangeReferenceDataDialog changeRefenceDataDialog;
    private SmartCardHSMCHVDialog dialog;
    private boolean usePinPad = false;

    public DefaultCHVManager(SmartCardHSMCardService service) {
        this.service = service;
    }

    public void useClassThreePinPad(boolean usePinPad) {
        this.usePinPad = usePinPad;
    }

    public boolean verifyPassword() throws CardServiceException, CardTerminalException {
        boolean verified = false;
        CardTerminalIOControl ioctl = new CardTerminalIOControl(0, 30, "0123456789", "");
        CHVControl cc = new CHVControl("Enter your password", 1, "String encoding", 0, ioctl);
        CHVCardServiceWithControl.PasswordStatus pws = this.service.getPasswordStatus(null, 1);
        if (pws == CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
            return true;
        }
        if (pws == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE) {
            this.changeRefenceDataDialog = new ChangeReferenceDataDialog();
            this.changeRefenceDataDialog.setPasswordStatus(pws);
            return this.changeReferenceData();
        }
        if (this.service.getPasswordStatus(null, 133) != CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
            byte[] template = new byte[]{127, 36, 0};
            return this.service.verifyBio((byte)-123, template);
        }
        if (this.usePinPad && this.service.hasSendVerifiedCommandAPDU()) {
            verified = this.service.verifyPassword(null, 0, cc, null);
        } else {
            this.dialog = new SmartCardHSMCHVDialog(this);
            this.dialog.setPasswordStatus(pws);
            String password = this.dialog.getCHV(-1);
            if (password == null) {
                pws = this.service.getPasswordStatus(null, 1);
                if (pws == CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    return true;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED) {
                    throw new CardServiceInvalidCredentialException("PIN is blocked");
                }
                throw new CardServiceOperationFailedException("PIN entry cancelled or change of User PIN failed");
            }
            byte[] passbytes = CHVUtils.encodeCHV((CHVControl)cc, (String)password);
            verified = this.service.verifyPassword(null, 0, passbytes);
        }
        return verified;
    }

    public boolean changeReferenceData() throws CardServiceException, CardTerminalException {
        CHVCardServiceWithControl.PasswordStatus status;
        if (this.changeRefenceDataDialog == null) {
            this.changeRefenceDataDialog = new ChangeReferenceDataDialog();
        }
        if ((status = this.service.getPasswordStatus(null, 1)) == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE) {
            this.changeRefenceDataDialog.setPasswordStatus(status);
        }
        if (!this.changeRefenceDataDialog.showDialog()) {
            throw new CardServiceInvalidCredentialException("CHV cancelled");
        }
        boolean modified = this.service.changeReferenceData(null, 129, null, this.changeRefenceDataDialog.getCurrentPIN(), this.changeRefenceDataDialog.getNewPIN());
        if (!modified) {
            this.changeRefenceDataDialog.setPasswordStatus(CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED);
        }
        return modified;
    }

    public String getCHV(int chvNumber) {
        return this.dialog.getCHV(-1);
    }
}

