/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.APDUTracerLogAdapter;
import de.cardcontact.cli.CardConnectorDaemon;
import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.ReaderConfigurationModel;
import de.cardcontact.cli.URLVerifier;
import de.cardcontact.opencard.service.remoteclient.RemoteClientCardService;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteUpdateService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.cert.CertPathBuilderException;
import java.util.Timer;
import java.util.TimerTask;
import opencard.core.OpenCardException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.APDUTracer;

public class CardUpdaterDaemon
extends CardConnectorDaemon
implements CTListener {
    static final int SERVER_PORT = 27001;
    static final int closingDelay = 60;
    private ServerSocket server;
    private byte[] passedImage;
    private byte[] failedImage;
    private URLVerifier urlVerifier;
    private Timer timer = new Timer();
    private SmartCardCloser scc = null;
    private boolean autoConnect = false;

    public CardUpdaterDaemon(CardUpdaterLog logger, ReaderConfigurationModel readerConfig, URLVerifier urlVerifier) throws IOException {
        super(logger, readerConfig, null);
        this.server = new ServerSocket(27001, 0, InetAddress.getByName(null));
        this.loadImages();
        this.urlVerifier = urlVerifier;
    }

    public void setAutoConnect(boolean ac) {
        this.autoConnect = ac;
    }

    private byte[] loadImage(String name) throws IOException {
        int r;
        InputStream is = CardUpdaterDaemon.class.getResourceAsStream(name);
        byte[] buffer = new byte[1024];
        int ofs = 0;
        int len = buffer.length;
        while ((r = is.read(buffer, ofs, len)) > 0) {
            ofs += r;
            len -= r;
        }
        byte[] rb = new byte[ofs];
        System.arraycopy(buffer, 0, rb, 0, ofs);
        return rb;
    }

    void loadImages() throws IOException {
        this.passedImage = this.loadImage("passed.png");
        this.failedImage = this.loadImage("failed.png");
    }

    void serveResponse(Socket con, boolean passed) throws IOException {
        byte[] image = passed ? this.passedImage : this.failedImage;
        OutputStream os = con.getOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
        out.write("HTTP/1.1 200 OK\r\n");
        out.write("Content-Length: " + image.length + "\r\n");
        out.write("\r\n");
        out.flush();
        os.write(image);
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest() {
        Socket con = null;
        boolean passed = false;
        try {
            block43: {
                String s;
                BufferedReader in;
                String methodAndUrl;
                this.log(1, "Daemon waiting on port 27001...");
                try {
                    con = this.server.accept();
                }
                catch (SocketException se) {
                    boolean bl = false;
                    if (con == null) return bl;
                    try {
                        con.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
                if (this.scc != null) {
                    this.scc.cancel();
                }
                if ((methodAndUrl = (in = new BufferedReader(new InputStreamReader(con.getInputStream()))).readLine()) == null) {
                    boolean bl = true;
                    return bl;
                }
                this.log(2, methodAndUrl);
                while ((s = in.readLine()) != null && !s.equals("")) {
                    this.log(2, s);
                }
                int sofs = methodAndUrl.indexOf(63);
                if (methodAndUrl.startsWith("GET /") && sofs > 0) {
                    int eofs = methodAndUrl.lastIndexOf(32);
                    String query = methodAndUrl.substring(sofs + 1, eofs);
                    String[] params = query.split("&");
                    String url = null;
                    String sessionId = null;
                    boolean pinRequired = false;
                    int chvNumber = -1;
                    for (String p : params) {
                        String[] keyvalue = p.split("=");
                        if (keyvalue[0].equals("url")) {
                            url = keyvalue[1];
                            continue;
                        }
                        if (keyvalue[0].equals("sessionId")) {
                            sessionId = keyvalue[1];
                            continue;
                        }
                        if (!keyvalue[0].equals("pinrequired")) continue;
                        pinRequired = true;
                        chvNumber = Integer.parseInt(keyvalue[1]);
                    }
                    if (url == null) {
                        this.log(1, "No URL defined in redirect");
                        boolean bl = true;
                        return bl;
                    }
                    boolean valid = this.verifyURL(url);
                    if (!valid) {
                        int n = 1;
                        return n != 0;
                    }
                    try {
                        if (this.card != null && !this.readerConfig.isCandidate(this.card.getCardID())) {
                            this.closeCard();
                            this.log(1, "Reader changed");
                        }
                        if (this.card == null) {
                            CardRequest cr = new CardRequest(1, null, RemoteClientCardService.class);
                            cr.setTimeout(0);
                            cr.setFilter((CardIDFilter)this.readerConfig);
                            this.card = SmartCard.waitForCard((CardRequest)cr);
                        }
                        if (this.card == null) {
                            this.log(1, "No card in reader");
                        } else {
                            SmartCard sc = this.card;
                            if (this.logger.getVerbosityLevel() > 1) {
                                sc.setAPDUTracer((APDUTracer)new APDUTracerLogAdapter(this.logger));
                            }
                            if (pinRequired) {
                                this.ensurePINVerification(sc, chvNumber);
                            }
                            this.log(1, "Connecting to " + url);
                            this.rus = (RemoteUpdateService)sc.getCardService(RemoteClientCardService.class, true);
                            this.rus.update(url, sessionId, (RemoteNotificationListener)this);
                            this.scc = new SmartCardCloser(this);
                            this.timer.schedule((TimerTask)this.scc, 60000L);
                            passed = true;
                        }
                    }
                    catch (Exception e) {
                        this.log(1, e.getMessage());
                        e.printStackTrace();
                        if (this.card == null) break block43;
                        this.card.close();
                        this.card = null;
                    }
                }
            }
            this.serveResponse(con, passed);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean verifyURL(String url) {
        if (this.urlVerifier == null) {
            return true;
        }
        this.log(2, "Verify URL " + (String)url);
        try {
            URL urlparts = new URL((String)url);
            url = urlparts.getProtocol() + "://" + urlparts.getHost();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return this.urlVerifier.verifyURL((String)url);
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        if (!this.autoConnect) {
            return;
        }
        CardTerminal ct = ctEvent.getCardTerminal();
        CardRequest cr = new CardRequest(1, ct, SmartCardHSMCardService.class);
        SmartCard sc = SmartCard.getSmartCard((CardTerminalEvent)ctEvent, (CardRequest)cr);
        if (sc == null) {
            this.log(1, "Inserted card is not a SmartCard-HSM");
            return;
        }
        if (this.logger.getVerbosityLevel() > 1) {
            sc.setAPDUTracer((APDUTracer)new APDUTracerLogAdapter(this.logger));
        }
        try {
            SmartCardHSMCardService cs = (SmartCardHSMCardService)sc.getCardService(SmartCardHSMCardService.class, false);
            String url = cs.getProvisioningURL();
            if (url == null) {
                this.log(1, "No provisioning URL found");
                return;
            }
            String id = cs.getId();
            if (this.urlVerifier != null && !this.urlVerifier.verifyURLforToken(url, id)) {
                this.log(1, "User denied auto connect");
                return;
            }
            this.readerConfig.ignoreTerminal(ct.getName());
            CardConnectorDaemon ccd = new CardConnectorDaemon(this.logger, this.readerConfig, sc);
            ccd.setPIN(this.presetPIN);
            ccd.setEnsurePIN(this.ensurePIN);
            ccd.setID(id);
            ccd.setURL(url);
            Thread daemonThread = new Thread((Runnable)ccd, "Background connector");
            daemonThread.setDaemon(true);
            daemonThread.start();
        }
        catch (ClassNotFoundException | CertPathBuilderException | OpenCardException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeCard() {
        super.closeCard();
        this.scc.cancel();
    }

    @Override
    public void run() {
        EventGenerator.getGenerator().addCTListener((CTListener)this);
        while (this.handleRequest()) {
        }
        this.timer.cancel();
        EventGenerator.getGenerator().removeCTListener((CTListener)this);
    }

    class SmartCardCloser
    extends TimerTask {
        CardUpdaterDaemon daemon;

        public SmartCardCloser(CardUpdaterDaemon daemon) {
            this.daemon = daemon;
        }

        @Override
        public void run() {
            if (this.daemon.card != null) {
                try {
                    this.daemon.card.close();
                    this.daemon.log(1, "Smartcard closed");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.daemon.card = null;
            }
        }
    }
}

