/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.APDUTracerLogAdapter;
import de.cardcontact.cli.CardConnectorDaemon;
import de.cardcontact.cli.CardUpdaterDaemon;
import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.ReaderConfigurationModel;
import de.cardcontact.cli.TerminalManager;
import de.cardcontact.cli.TrayView;
import de.cardcontact.cli.URLVerifier;
import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.factory.RemoteClientCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import de.cardcontact.opencard.service.remoteclient.RemoteClientCardService;
import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOFactory;
import java.io.IOException;
import java.util.Enumeration;
import opencard.core.OpenCardException;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.APDUTracer;

public class CardUpdater
implements CardUpdaterLog {
    private String readerName = null;
    private String url = null;
    private String session = null;
    private byte[] pin = null;
    private int verbose = 1;
    private boolean reset = true;
    private boolean listReaders = false;
    private boolean password = false;
    private boolean showLog = false;
    private boolean autoConnect = false;
    private TerminalManager terminalManager = new TerminalManager();

    @Override
    public void log(int level, String msg) {
        if (this.verbose >= level) {
            System.out.println(msg);
        }
    }

    @Override
    public int getVerbosityLevel() {
        return this.verbose;
    }

    private void setupOCF() throws OpenCardException, ClassNotFoundException {
        SmartCard.startup();
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        SmartCardIOFactory ctf = new SmartCardIOFactory();
        String[] param = new String[]{"*", "PCSC"};
        ctf.createCardTerminals(ctr, param);
        CardServiceRegistry csr = CardServiceRegistry.getRegistry();
        RemoteClientCardServiceFactory csf = new RemoteClientCardServiceFactory();
        csr.add((CardServiceFactory)csf);
        csf = new SmartCardHSMCardServiceFactory();
        csr.add((CardServiceFactory)csf);
        csf = new IsoCardServiceFactory();
        csr.add((CardServiceFactory)csf);
    }

    private void help() {
        System.out.println("Usage: java -jar ocf-cc.jar [-r <readername>] [-s <id>] [-n] [-l] [-w] [-v] [<url>]\n");
        System.out.println("-n\t\tNo card reset at end of session");
        System.out.println("-s <id>\t\tSession id");
        System.out.println("-a\t\tAuto connect if inserted device has provisioning URL");
        System.out.println("-w\t\tOpen log window");
        System.out.println("-l\t\tList reader names");
        System.out.println("-v\t\tVerbose");
        System.out.println("-q\t\tQuiet");
        System.out.println("-p\t\tPassword verification");
        System.out.println("An URL on the command line deactivates the daemon mode and connects directly with that URL");
    }

    private boolean decodeArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-r")) {
                this.readerName = args[++i];
                continue;
            }
            if (args[i].equals("-s")) {
                this.session = args[++i];
                continue;
            }
            if (args[i].equals("-v")) {
                ++this.verbose;
                continue;
            }
            if (args[i].equals("-q")) {
                --this.verbose;
                continue;
            }
            if (args[i].equals("-n")) {
                this.reset = false;
                continue;
            }
            if (args[i].equals("-a")) {
                this.autoConnect = true;
                continue;
            }
            if (args[i].equals("-l")) {
                this.listReaders = true;
                continue;
            }
            if (args[i].equals("-w")) {
                this.showLog = true;
                continue;
            }
            if (args[i].equals("--")) continue;
            if (args[i].equals("-p")) {
                this.password = true;
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue;
                this.pin = args[++i].getBytes();
                continue;
            }
            if (args[i].charAt(0) == '-') {
                this.log(1, "Unknown option " + args[i]);
                return false;
            }
            this.url = args[i];
        }
        return true;
    }

    private void listReaders() {
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        Enumeration ctlist = ctr.getCardTerminals();
        if (this.listReaders) {
            System.out.println("Available card terminals:");
            while (ctlist.hasMoreElements()) {
                CardTerminal ct = (CardTerminal)ctlist.nextElement();
                System.out.println(" " + ct.getName());
            }
            System.out.println("");
        }
    }

    private void startDaemon() throws IOException {
        if (this.readerName != null) {
            this.terminalManager.setSelectedTerminal(this.readerName);
        }
        CardUpdaterDaemon updaterDaemon = new CardUpdaterDaemon((CardUpdaterLog)this, (ReaderConfigurationModel)this.terminalManager, new URLVerifier());
        updaterDaemon.setAutoConnect(this.autoConnect);
        updaterDaemon.setEnsurePIN(this.password);
        if (this.pin != null) {
            updaterDaemon.setPIN(this.pin);
        }
        TrayView view = new TrayView(this.terminalManager);
        if (this.showLog) {
            view.showLog();
        }
        Thread daemonThread = new Thread((Runnable)updaterDaemon, "Redirect Handler");
        daemonThread.setDaemon(true);
        daemonThread.start();
    }

    private void connectToServer() throws OpenCardException, ClassNotFoundException {
        SmartCard sc;
        CardTerminal ct = null;
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        if (this.readerName != null) {
            ct = ctr.cardTerminalForName(this.readerName);
            if (ct == null) {
                this.log(1, "Card reader " + this.readerName + " not found");
                System.exit(1);
            }
            this.log(1, "Using reader " + this.readerName);
        }
        CardRequest cr = new CardRequest(1, ct, RemoteClientCardService.class);
        cr.setTimeout(0);
        if (ct == null) {
            cr.setFilter((CardIDFilter)this.terminalManager);
        }
        if ((sc = SmartCard.waitForCard((CardRequest)cr)) == null) {
            this.log(1, "No card in reader");
            return;
        }
        if (this.getVerbosityLevel() > 1) {
            sc.setAPDUTracer((APDUTracer)new APDUTracerLogAdapter(this));
        }
        CardConnectorDaemon ccd = new CardConnectorDaemon(this, null, sc);
        if (this.pin != null) {
            ccd.setPIN(this.pin);
        }
        ccd.setEnsurePIN(this.password);
        ccd.setURL(this.url);
        ccd.setSession(this.session);
        ccd.run();
        if (this.reset) {
            try {
                sc.reset(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sc.close();
    }

    public void run(String[] args) {
        if (!this.decodeArgs(args)) {
            this.help();
            System.exit(1);
        }
        try {
            this.setupOCF();
            this.log(1, SmartCard.getVersion());
            if (this.listReaders) {
                this.listReaders();
            } else if (this.url == null) {
                this.startDaemon();
            } else {
                this.connectToServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.url != null) {
                    SmartCard.shutdown();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        CardUpdater cu = new CardUpdater();
        cu.run(args);
    }
}

