/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.tlv.HexString;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUFormatter;
import opencard.core.util.APDUTracer;

public class APDUTracerLogAdapter
implements APDUTracer {
    private CardUpdaterLog logger;

    public APDUTracerLogAdapter(CardUpdaterLog logger) {
        this.logger = logger;
    }

    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        int slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
        String s = HexString.hexifyByte((int)slotId);
        s = s.concat(" ");
        s = s.concat(APDUFormatter.commandAPDUToString((CommandAPDU)capdu));
        this.logger.log(2, s);
    }

    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        String s = APDUFormatter.responseAPDUToString((ResponseAPDU)rapdu);
        this.logger.log(2, s);
    }

    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        this.logger.log(2, " ATR: " + HexString.hexifyByteArray((byte[])cardID.getATR()));
    }
}

