/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.ui;

import opencard.core.service.CHVDialog;
import opencard.core.service.CHVUtils;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.ui.DefaultCHVDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardHolderVerificationGUI {
    private static final Logger logger = LoggerFactory.getLogger(CardHolderVerificationGUI.class);
    private int chvNumber = -1;
    private CHVDialog chvDialog = new DefaultCHVDialog();

    protected CardHolderVerificationGUI() {
    }

    protected void clearDisplay() {
        this.chvNumber = -1;
    }

    protected void display(int num) {
        this.chvNumber = num;
    }

    protected String keyboardInput(CardTerminalIOControl ioControl, CHVDialog customCHVDialog) {
        if (customCHVDialog != null) {
            return customCHVDialog.getCHV(this.chvNumber);
        }
        return this.chvDialog.getCHV(this.chvNumber);
    }

    protected String promptUser(int chvNumber, CardTerminalIOControl ioControl, CHVDialog customCHVDialog) {
        this.clearDisplay();
        this.display(chvNumber);
        return this.keyboardInput(ioControl, customCHVDialog);
    }

    @Deprecated
    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotchan, CommandAPDU command, CHVControl control, CHVDialog dialog, int timeout) throws CardTerminalException, CardServiceInvalidCredentialException {
        return this.sendVerifiedAPDU(slotchan, command, control, dialog);
    }

    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotchan, CommandAPDU command, CHVControl control, CHVDialog dialog) throws CardTerminalException, CardServiceInvalidCredentialException {
        String password = this.promptUser(control.chvNumber(), control.ioControl(), dialog);
        if (password == null) {
            throw new CardServiceInvalidCredentialException("CHV cancelled");
        }
        byte[] passbytes = CHVUtils.encodeCHV((CHVControl)control, (String)password);
        int length = passbytes.length;
        int offset = control.passwordOffset();
        if (command.getLength() < 5) {
            command.append((byte)length);
            System.arraycopy(passbytes, 0, command.getBuffer(), 5, length);
            command.setLength(5 + length);
        } else {
            for (int i = 0; i < length; ++i) {
                command.setByte(5 + offset + i, (int)passbytes[i]);
            }
        }
        if (!slotchan.isOpen()) {
            throw new CardTerminalException("SlotChannel closed");
        }
        ResponseAPDU response = slotchan.sendAPDU(command);
        return response;
    }
}

