/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.daemon;

import de.cardcontact.opencard.daemon.CardUpdaterLog;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteUpdateService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.ReaderConfigurationModel;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.applet.AppletID;
import opencard.opt.security.CHVCardService;
import opencard.opt.security.SecurityDomain;

public class CardConnectorDaemon
implements Runnable,
CTListener,
RemoteNotificationListener {
    ReaderConfigurationModel readerConfig;
    CardUpdaterLog logger;
    int lastMessageId = 0;
    boolean ensurePIN = false;
    byte[] presetPIN = null;
    SmartCard card = null;
    String url = null;
    String session = null;
    String id = "unknown";
    RemoteUpdateService rus;

    public CardConnectorDaemon(CardUpdaterLog logger, ReaderConfigurationModel readerConfig, SmartCard card) {
        this.logger = logger;
        this.readerConfig = readerConfig;
        this.card = card;
    }

    public void log(int level, String msg) {
        this.logger.log(level, msg);
    }

    static String PINStatusString(CHVCardServiceWithControl.PasswordStatus pws) {
        switch (pws) {
            case VERIFIED: {
                return "PIN verified";
            }
            case NOTVERIFIED: {
                return "PIN not verified";
            }
            case BLOCKED: {
                return "PIN is blocked";
            }
            case LASTTRY: {
                return "Last PIN try";
            }
            case NOTINITIALIZED: {
                return "PIN not initialized";
            }
            case RETRYCOUNTERLOW: {
                return "PIn retry counter low";
            }
            case TRANSPORTMODE: {
                return "PIN in transport mode";
            }
        }
        return "Unknown";
    }

    public void setPIN(byte[] pin) {
        this.presetPIN = pin;
    }

    public void setEnsurePIN(boolean ensurePIN) {
        this.ensurePIN = ensurePIN;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setSession(String session) {
        this.session = session;
    }

    private void connectTo(String url) throws CardServiceException, ClassNotFoundException {
        this.rus = (RemoteUpdateService)this.card.getCardService(RemoteUpdateService.class, true);
        if (this.rus == null) {
            this.log(1, "No remote update service available");
        } else {
            this.log(1, "Connecting to " + url);
            this.rus.update(url, this.session, (RemoteNotificationListener)this);
            this.log(1, "Connection of token " + this.id + " to " + url + " completed");
        }
    }

    void ensurePINVerification(SmartCard sc, AppletID aid, int chvNumber) throws CardServiceException, ClassNotFoundException, CardTerminalException {
        CHVCardService chv = (CHVCardService)sc.getCardService(CHVCardService.class, true);
        boolean verified = true;
        try {
            if (chv instanceof CHVCardServiceWithControl) {
                CHVCardServiceWithControl chvcc = (CHVCardServiceWithControl)chv;
                CHVCardServiceWithControl.PasswordStatus pws = null;
                try {
                    pws = chvcc.getPasswordStatus((SecurityDomain)aid, chvNumber);
                }
                catch (CardServiceUnexpectedStatusWordException e) {
                    this.log(1, "Unexpected SW1/SW2 received from card. Supported card in reader ?");
                    return;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                    this.log(1, CardConnectorDaemon.PINStatusString(pws));
                    return;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED) {
                    if (!(chv instanceof SmartCardHSMCardService)) {
                        this.log(1, "Blocked card is not a SmartCard-HSM");
                        return;
                    }
                    SmartCardHSMCardService cs = (SmartCardHSMCardService)chv;
                    String url = cs.getProvisioningURL();
                    if (url == null) {
                        this.log(1, "Blocked card does not have a provisioning URL");
                        return;
                    }
                    try {
                        this.connectTo(url);
                        pws = chvcc.getPasswordStatus(null, chvNumber);
                    }
                    catch (Exception e) {
                        this.log(1, "Remote connection failed with " + e.getMessage());
                    }
                    if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED || pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                        this.log(1, "Blocked card still blocked after provisioning");
                        return;
                    }
                }
                if (pws != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    try {
                        verified = chvcc.verifyPassword((SecurityDomain)aid, chvNumber, this.presetPIN);
                    }
                    catch (CardServiceUnexpectedStatusWordException e) {
                        this.log(1, "PIN verification failed: " + e.getMessage());
                    }
                }
            } else {
                verified = chv.verifyPassword(null, chvNumber, this.presetPIN);
            }
            this.log(1, "PIN verified: " + verified);
        }
        catch (CardServiceInvalidCredentialException | CardServiceOperationFailedException e) {
            this.log(1, "PIN verification cancelled by user");
        }
    }

    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
    }

    public void closeCard() {
        this.rus.cancel();
        this.card = null;
    }

    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        CardTerminal ct;
        if (this.card != null && (ct = this.card.getCardID().getCardTerminal()) != null && ctEvent.getCardTerminal().equals(ct)) {
            this.closeCard();
            this.log(1, "Card removed");
        }
    }

    public void remoteNotify(int id, String message, int ttc) {
        this.lastMessageId = id;
        this.log(1, message);
    }

    @Override
    public void run() {
        EventGenerator.getGenerator().addCTListener((CTListener)this);
        String ctname = this.card.getCardID().getCardTerminal().getName();
        try {
            if (this.ensurePIN) {
                this.ensurePINVerification(this.card, null, 1);
            }
            this.connectTo(this.url);
        }
        catch (Exception e) {
            this.log(1, "Remote connection failed with " + e.getMessage());
        }
        finally {
            if (this.readerConfig != null) {
                this.readerConfig.approveTerminal(ctname);
            }
            EventGenerator.getGenerator().removeCTListener((CTListener)this);
        }
    }
}

