/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.daemon;

import de.cardcontact.opencard.daemon.ReaderConfigurationModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ReaderConfigurationView
extends JFrame {
    private ReaderConfigurationModel readerConfigurationModel;
    private JButton okButton;
    private JScrollPane ignoredScrollPanel;
    private JPanel ignorePanel;
    private JComboBox<String> selectionCB;
    private DefaultComboBoxModel<String> comboBoxModel;
    private JLabel noReaderLabel;

    public ReaderConfigurationView(ReaderConfigurationModel rcm) {
        URL iconURL = ReaderConfigurationView.class.getResource("cardcontact_24bit.gif");
        ImageIcon icon = new ImageIcon(iconURL);
        this.setIconImage(icon.getImage());
        this.readerConfigurationModel = rcm;
        this.init();
        this.setLocationRelativeTo(null);
    }

    public void init() {
        this.setTitle("Card Reader Configuration");
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        int y = 0;
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.comboBoxModel = new DefaultComboBoxModel();
        this.selectionCB = new JComboBox<String>(this.comboBoxModel);
        this.selectionCB.setBorder(BorderFactory.createTitledBorder("Use Reader"));
        this.ignoredScrollPanel = new JScrollPane();
        TitledBorder title = BorderFactory.createTitledBorder("Ignore Reader");
        this.ignoredScrollPanel.setBorder(title);
        this.ignoredScrollPanel.setVerticalScrollBarPolicy(20);
        this.ignoredScrollPanel.setHorizontalScrollBarPolicy(30);
        Dimension d = new Dimension(0, 65);
        this.ignoredScrollPanel.setMinimumSize(d);
        c.gridy = y++;
        c.fill = 2;
        contentPane.add(this.selectionCB, c);
        c.gridy = y++;
        contentPane.add((Component)this.ignoredScrollPanel, c);
        JPanel buttons = new JPanel(new FlowLayout());
        this.okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        JButton refreshButton = new JButton("Refresh");
        buttons.add(this.okButton);
        buttons.add(cancelButton);
        buttons.add(refreshButton);
        c.gridy = y++;
        contentPane.add((Component)buttons, c);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReaderConfigurationView.this.showView();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = ReaderConfigurationView.this.selectionCB.getSelectedItem();
                if (selected != null) {
                    String reader = (String)selected;
                    if (reader.equals("any")) {
                        reader = "";
                    }
                    ReaderConfigurationView.this.readerConfigurationModel.setSelectedTerminal(reader);
                }
                ReaderConfigurationView.this.readerConfigurationModel.saveSettings();
                ReaderConfigurationView.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReaderConfigurationView.this.readerConfigurationModel.discardChanges();
                ReaderConfigurationView.this.setVisible(false);
            }
        });
        this.setContentPane(contentPane);
        this.pack();
    }

    public void showView() {
        this.updateIgnoreReaderList();
        this.preselectDefaultReader();
        this.revalidate();
        this.repaint();
        this.pack();
        this.setVisible(true);
    }

    private void preselectDefaultReader() {
        this.updateReaderCB();
        String defaultReader = this.readerConfigurationModel.getSelectedTerminal();
        int listIndex = this.comboBoxModel.getIndexOf(defaultReader);
        if (this.comboBoxModel.getElementAt(listIndex) != null) {
            this.selectionCB.setSelectedIndex(listIndex);
        }
    }

    private void updateIgnoreReaderList() {
        HashSet<String> ignored = this.readerConfigurationModel.getIgnoredTerminals();
        this.ignorePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        int y = 0;
        for (String reader : this.readerConfigurationModel.getAllTerminals()) {
            JCheckBox cb = new JCheckBox(reader);
            if (ignored.contains(reader)) {
                cb.setSelected(true);
            }
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    JCheckBox cb = (JCheckBox)event.getItem();
                    if (event.getStateChange() == 1) {
                        ReaderConfigurationView.this.readerConfigurationModel.ignoreTerminal(cb.getText());
                    } else {
                        ReaderConfigurationView.this.readerConfigurationModel.approveTerminal(cb.getText());
                    }
                    ReaderConfigurationView.this.updateReaderCB();
                }
            });
            c.gridy = y++;
            this.ignorePanel.add((Component)cb, c);
        }
        this.ignoredScrollPanel.setViewportView(this.ignorePanel);
        if (y == 0) {
            this.ignoredScrollPanel.setVisible(false);
        } else {
            this.ignoredScrollPanel.setVisible(true);
        }
    }

    private void updateReaderCB() {
        Object selection = this.comboBoxModel.getSelectedItem();
        this.comboBoxModel.removeAllElements();
        this.comboBoxModel.addElement("any");
        for (String reader : this.readerConfigurationModel.getValidTerminals()) {
            this.comboBoxModel.addElement(reader);
        }
        if (selection == null || this.comboBoxModel.getIndexOf(selection) == -1) {
            selection = this.comboBoxModel.getElementAt(0);
        }
        this.comboBoxModel.setSelectedItem(selection);
        this.pack();
    }
}

