/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.daemon;

import de.cardcontact.opencard.daemon.ServerURLManager;
import java.awt.Dialog;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class URLVerifier {
    private ServerURLManager manager = new ServerURLManager();
    private static final int OPTION_ALWAYS = 0;
    private static final int OPTION_ONCE = 1;
    private static final int OPTION_NO = 2;

    private int prompt(String title, String message, String[] options) {
        int n;
        JOptionPane pane = new JOptionPane(message, 3, 1, null, options, null);
        JDialog dialog = pane.createDialog(title);
        dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        dialog.setLocationRelativeTo(null);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        Object value = pane.getValue();
        if (value == null) {
            return -1;
        }
        for (n = 0; n < options.length && !value.equals(options[n]); ++n) {
        }
        return n;
    }

    public boolean verifyURL(String url) {
        if (this.manager.isApproved(url)) {
            return true;
        }
        String[] options = new String[]{"Yes, always", "Yes, only once", "No"};
        String title = "Incoming Connection";
        String message = "The server \n" + url + "\nis trying to connect to your smart card.\n\nDo you wish to allow the connection ?";
        int n = this.prompt(title, message, options);
        if (n == 0) {
            this.manager.approveServerURL(url);
            return true;
        }
        return n == 1;
    }

    public boolean verifyURLforToken(String url, String token) {
        String[] options = new String[]{"Yes", "No"};
        String message = "Connect token " + token + " to server at " + url + " ?";
        int opt = this.prompt("Auto connect token", message, options);
        return opt == 0;
    }
}

