/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.HexString;

public class ByteBuffer {
    byte[] buffer = null;
    int length = 0;

    public ByteBuffer() {
        this(16);
    }

    public ByteBuffer(int length) {
        this.buffer = new byte[length];
    }

    public ByteBuffer(byte[] bytes) {
        this.buffer = bytes;
        this.length = bytes.length;
    }

    public ByteBuffer append(byte _byte) {
        return this.insert(this.length, _byte);
    }

    public ByteBuffer append(byte[] bytes) {
        return this.insert(this.length, bytes);
    }

    public ByteBuffer append(ByteBuffer bb) {
        return this.insert(this.length, bb);
    }

    void ensureCapacity(int newCapacity) {
        if (newCapacity > this.buffer.length) {
            int newSize = (this.buffer.length << 1) + 2;
            if (newCapacity > newSize) {
                newSize = newCapacity;
            }
            byte[] newbuffer = new byte[newSize];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.length);
            this.buffer = newbuffer;
        }
    }

    public ByteBuffer insert(int offset, byte[] bytes, int length) throws IndexOutOfBoundsException {
        if (offset > this.length || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.length + length);
        System.arraycopy(this.buffer, offset, this.buffer, offset + length, this.length - offset);
        System.arraycopy(bytes, 0, this.buffer, offset, length);
        this.length += length;
        return this;
    }

    public ByteBuffer insert(int offset, byte _byte) throws IndexOutOfBoundsException {
        return this.insert(offset, new byte[]{_byte}, 1);
    }

    public ByteBuffer insert(int offset, byte[] bytes) throws IndexOutOfBoundsException {
        return this.insert(offset, bytes, bytes.length);
    }

    public ByteBuffer insert(int offset, ByteBuffer bb) throws IndexOutOfBoundsException {
        return this.insert(offset, bb.buffer, bb.length);
    }

    public int length() {
        return this.length;
    }

    public byte getByteAt(int offset) throws IndexOutOfBoundsException {
        if (offset < 0 || offset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[offset];
    }

    public ByteBuffer clear(int offset, int count) throws IndexOutOfBoundsException {
        if (offset < 0 || count < 0 || offset + count > this.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, offset + count, this.buffer, offset, this.length - (offset + count));
        this.length -= count;
        return this;
    }

    public ByteBuffer copy(int offset, byte[] source) {
        if (offset < 0 || offset + source.length > this.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(source, 0, this.buffer, offset, source.length);
        return this;
    }

    public static int find(byte[] source, int length, byte[] search, int offset) {
        while (offset + search.length <= length) {
            int i;
            for (i = 0; i < search.length && source[offset + i] == search[i]; ++i) {
            }
            if (i == search.length) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int find(byte[] source, byte[] search, int offset) {
        return ByteBuffer.find(source, source.length, search, offset);
    }

    public int find(byte[] search, int offset) {
        return ByteBuffer.find(this.buffer, this.length, search, offset);
    }

    public byte[] getBytes() {
        byte[] response = new byte[this.length];
        System.arraycopy(this.buffer, 0, response, 0, this.length);
        return response;
    }

    public byte[] getBytes(int offset, int count) {
        byte[] response = new byte[count];
        System.arraycopy(this.buffer, offset, response, 0, count);
        return response;
    }

    public String toString() {
        return HexString.hexifyByteArray(this.buffer, ' ', this.length);
    }
}

