/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.SecureChannelCredential;
import opencard.core.terminal.CardID;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.Credential;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;

public class IsoCredentialStore
extends CredentialStore {
    public static final int SELECT = 1;
    public static final int READ = 2;
    public static final int UPDATE = 4;
    public static final int APPEND = 8;
    public static final int CREATE = 16;
    public static final int DELETE = 32;
    public static final int ACTIVATE = 64;
    public static final int DEACTIVATE = 128;
    public static final int SIZE_ACCESS_MATRIX = 8;

    @Override
    public boolean supports(CardID cardID) {
        return true;
    }

    public void setSecureChannelCredential(SecurityDomain sd, SecureChannelCredential scc) {
        this.storeCredential(sd, scc);
    }

    public SecureChannelCredential getSecureChannelCredential(SecurityDomain sd) {
        Credential c = this.fetchCredential(sd);
        if (c instanceof SecureChannelCredential) {
            SecureChannelCredential scc = (SecureChannelCredential)c;
            return scc;
        }
        return null;
    }

    public SecureChannelCredential getSecureChannelCredential(SecurityDomain sd, int accessMode) {
        CardFilePath path = new CardFilePath((CardFilePath)sd);
        do {
            Credential c;
            if ((c = this.fetchCredential(path.toString() + "@" + accessMode)) == null) {
                c = this.fetchCredential(path);
            }
            if (c == null || !(c instanceof SecureChannelCredential)) continue;
            SecureChannelCredential scc = (SecureChannelCredential)c;
            return scc;
        } while (path.chompTail());
        CardFilePath rootPath = new CardFilePath(":3F00");
        if (!path.equals(rootPath)) {
            Credential c = this.fetchCredential(rootPath.toString() + "@" + accessMode);
            if (c == null) {
                c = this.fetchCredential(rootPath);
            }
            if (c != null && c instanceof SecureChannelCredential) {
                SecureChannelCredential scc = (SecureChannelCredential)c;
                return scc;
            }
        }
        return null;
    }

    public void setSecureChannelCredential(SecurityDomain sd, int accessMode, SecureChannelCredential scc) {
        for (int i = 0; i < 8; ++i) {
            if ((accessMode & 1 << i) <= 0) continue;
            this.storeCredential(sd.toString() + "@" + (1 << i), scc);
        }
    }
}

