/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeySet;
import de.cardcontact.opencard.security.GPSecureChannel;
import opencard.core.OpenCardException;

public abstract class GPSCPAuthenticator {
    public static final byte LEVEL_NONE = 0;
    public static final byte LEVEL_CMAC = 1;
    public static final byte LEVEL_CMAC_CENC = 3;
    public static final byte LEVEL_CRMAC_CRENC = 51;
    byte[] hostChallenge;
    byte[] keyDiversificationData;
    byte[] keyInformation;
    byte[] sequenceCounter;
    byte[] cardChallenge;
    byte[] cardCryptogram;
    GPKeySet sessionKeys;
    GPSecureChannel secureChannel;

    public GPSCPAuthenticator(byte[] hostChallenge) {
        this.hostChallenge = hostChallenge;
    }

    public abstract void processInitializeUpdateResponse(byte[] var1) throws OpenCardException;

    public abstract void deriveSessionKeys(GPKeySet var1);

    public abstract boolean isCardCryptogramValid();

    public abstract byte[] calculateHostCryptogram(byte var1);

    public byte getKeyVersion() {
        return this.keyInformation[0];
    }

    public byte getSCPVersion() {
        return this.keyInformation[1];
    }

    public byte[] getKeyDiversificationData() {
        return this.keyDiversificationData;
    }

    public GPSecureChannel getSecureChannel() {
        return this.secureChannel;
    }

    public GPKeySet getSessionKeys() {
        return this.sessionKeys;
    }
}

