/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;

public abstract class SmartCardHSMPrivateKeySpec
extends SmartCardHSMKeySpec {
    byte[] algorithm;
    private String chr;
    private String car;
    private String outerCar;
    private boolean storePublicKey = true;

    public SmartCardHSMPrivateKeySpec(String car, String chr) {
        this.setCAR(car);
        this.setCHR(chr);
    }

    public byte[] getCHR() {
        return this.chr.getBytes();
    }

    public void setCHR(String certificateHolderReference) {
        this.chr = certificateHolderReference;
    }

    public byte[] getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(byte[] algorithm) {
        this.algorithm = algorithm;
    }

    public void setCAR(String car) {
        this.car = car;
    }

    public void setOuterCAR(String outerCar) {
        this.outerCar = outerCar;
    }

    public void setStorePublicKey(boolean storePublicKey) {
        this.storePublicKey = storePublicKey;
    }

    public boolean storePublicKey() {
        return this.storePublicKey;
    }

    protected abstract ConstructedTLV encodeKeyParams();

    @Override
    protected void encodeSpecParams(Sequence cdata) {
        cdata.add(new PrimitiveTLV(new Tag(41, 64, false), new byte[]{0}));
        if (this.car != null) {
            cdata.add(new PrimitiveTLV(new Tag(2, 64, false), this.car.getBytes()));
        }
        cdata.add(this.encodeKeyParams());
        cdata.add(new PrimitiveTLV(new Tag(32, 64, false), this.getCHR()));
        if (this.outerCar != null) {
            cdata.add(new PrimitiveTLV(new Tag(2, 64, false), this.outerCar.getBytes()));
        }
    }

    protected static byte[] unsignedBigIntegerToByteArray(BigInteger bi, int size) {
        byte[] s = bi.toByteArray();
        size = (size >> 3) + ((size & 7) == 0 ? 0 : 1);
        byte[] d = new byte[size];
        int od = size - s.length;
        int os = 0;
        if (od < 0) {
            if (od < -1 || s[0] != 0) {
                throw new IllegalArgumentException("Size mismatch converting big integer to byte array");
            }
            os = -od;
            od = 0;
        }
        System.arraycopy(s, os, d, od, size -= od);
        return d;
    }
}

