/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.SystemAccess;

public class OpenCardPropertyFileLoader
implements OpenCardConfigurationProvider {
    private boolean loadingDone = false;

    protected void load(String location) {
        try {
            SystemAccess sys = SystemAccess.getSystemAccess();
            Properties props = sys.loadProperties(location);
            this.loadingDone = true;
            Properties sysProps = sys.getProperties();
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                String override = (String)props.get(key + ".override");
                if (sysProps.containsKey(key) && !Boolean.valueOf(override).booleanValue()) continue;
                sysProps.put(key, props.get(key));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void loadProperties() throws OpenCardPropertyLoadingException {
        if (!this.loadingDone) {
            String dotPropStr = ".opencard.properties";
            String propStr = "opencard.properties";
            SystemAccess sys = SystemAccess.getSystemAccess();
            String[] locations = new String[]{sys.getProperty("java.home", "") + File.separator + "lib" + File.separator + propStr, sys.getProperty("user.home", "") + File.separator + dotPropStr, sys.getProperty("user.dir", "") + File.separator + propStr, sys.getProperty("user.dir", "") + File.separator + dotPropStr};
            for (int index = 0; index < locations.length; ++index) {
                this.load(locations[index]);
            }
            if (!this.loadingDone) {
                throw new OpenCardPropertyLoadingException("property file not found");
            }
        }
    }
}

