/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.terminal.CardID;
import opencard.opt.security.Credential;

public abstract class CredentialStore {
    private Hashtable credentialTable = new Hashtable();

    protected CredentialStore() {
    }

    public abstract boolean supports(CardID var1);

    public static CredentialStore getInstance(String className) {
        CredentialStore store = null;
        try {
            Class<?> clazz = Class.forName(className);
            store = (CredentialStore)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return store;
    }

    protected final void storeCredential(Object credID, Credential cred) {
        if (cred != null) {
            this.credentialTable.put(credID, cred);
        }
    }

    protected final Credential fetchCredential(Object credID) {
        return (Credential)this.credentialTable.get(credID);
    }

    protected final Enumeration getCredentialIDs() {
        return this.credentialTable.keys();
    }
}

