/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.TLVEncodingException;

public class Tag {
    int tagNumber;
    byte tagClass;
    boolean constructed;
    boolean invalidTagNumber = false;
    public static final byte CONSTRUCTED = 32;
    public static final byte CLASS = -64;
    public static final byte TAG = 31;
    public static final byte UNIVERSAL = 0;
    public static final byte APPLICATION = 64;
    public static final byte CONTEXT = -128;
    public static final byte PRIVATE = -64;
    public static final int END_OF_CONTENTS = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int OBJECT_DESCRIPTOR = 7;
    public static final int EXTERNAL_TYPE = 8;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int EMBEDDED_PDV = 11;
    public static final int UTF8String = 12;
    public static final int RELATIVE_OID = 13;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NumericString = 18;
    public static final int PrintableString = 19;
    public static final int T61String = 20;
    public static final int IA5String = 22;
    public static final int UTCTime = 23;
    public static final int GeneralizedTime = 24;
    public static final int GeneralString = 27;
    public static final int UniversalString = 28;
    public static final int BMPString = 30;
    public static final Tag TAG_INTEGER = new Tag(2, 0, false);
    public static final Tag TAG_BIT_STRING = new Tag(3, 0, false);
    public static final Tag TAG_OCTET_STRING = new Tag(4, 0, false);
    public static final Tag TAG_OBJECT_IDENTIFIER = new Tag(6, 0, false);
    public static final Tag TAG_SEQUENCE = new Tag(16, 0, true);
    public static final Tag TAG_SET = new Tag(17, 0, true);
    public static final Tag TAG_UTF8String = new Tag(12, 0, false);
    public static final Tag TAG_PrintableString = new Tag(19, 0, false);
    public static final Tag TAG_NumericString = new Tag(18, 0, false);
    static final String[] ClassText = new String[]{"UNIVERSAL", "APPLICATION", "CONTEXT", "PRIVATE"};
    static final String[] UniversalText = new String[]{"END-OF-CONTENTS", "BOOLEAN", "INTEGER", "BIT-STRING", "OCTET-STRING", "NULL", "OBJECT-IDENTIFIER", "OBJECT-DESCRIPTOR", "EXTERNAL-TYPE/INSTANCE-OF", "REAL", "ENUMERATED", "EMBEDDED-PDV", "UTF8-STRING", "RFU", "RFU", "RFU", "SEQUENCE", "SET", "NUMERIC-STRING", "PRINTABLE-STRING", "TELETEXT-STRING", "VIDEOTEXT-STRING", "IA5-STRING", "UTC", "GENERALIZED-TIME", "GRAPHIC-STRING", "VISIBLE-STRING", "GENERAL-STRING", "UNIVERSAL-STRING", "RFU", "BMP-STRING"};

    public Tag(int newTag, byte newClass, boolean newConstructed) {
        this.tagNumber = newTag;
        this.tagClass = newClass;
        this.constructed = newConstructed;
    }

    public Tag(ParseBuffer pb) throws TLVEncodingException {
        byte temp = pb.get();
        this.tagClass = (byte)(temp & 0xFFFFFFC0);
        this.constructed = (temp & 0x20) == 32;
        this.tagNumber = temp & 0x1F;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            int i = 4;
            do {
                temp = pb.get();
                this.tagNumber <<= 7;
                this.tagNumber |= temp & 0x7F;
            } while ((temp & 0x80) == 128 && --i > 0);
            this.invalidTagNumber = this.tagNumber < 31;
        }
    }

    public Tag(byte[] value, int offset) {
        byte temp = value[offset];
        this.tagClass = (byte)(temp & 0xFFFFFFC0);
        this.constructed = (temp & 0x20) == 32;
        this.tagNumber = temp & 0x1F;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            ++offset;
            int i = 4;
            do {
                temp = value[offset];
                this.tagNumber <<= 7;
                this.tagNumber |= temp & 0x7F;
                ++offset;
            } while ((temp & 0x80) == 128 && --i > 0);
            this.invalidTagNumber = this.tagNumber < 31;
        }
    }

    public Tag(byte[] value) {
        this(value, 0);
    }

    public Tag(int newTag) throws TLVEncodingException {
        int size = newTag >= 0x1000000 || newTag < 0 ? 24 : (newTag >= 65536 ? 16 : (newTag >= 256 ? 8 : 0));
        int temp = newTag >> size;
        this.tagClass = (byte)(temp & 0xFFFFFFC0);
        this.constructed = (temp & 0x20) == 32;
        this.tagNumber = temp & 0x1F;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            do {
                temp = newTag >> (size -= 8) & 0xFF;
                this.tagNumber <<= 7;
                this.tagNumber |= temp & 0x7F;
            } while (size > 0);
            this.invalidTagNumber = this.tagNumber < 31;
        } else if (size > 0) {
            throw new TLVEncodingException("Multi-byte tag does not have all bits b5 to b1 set 1");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag t = (Tag)object;
        return this.tagNumber == t.tagNumber && this.tagClass == t.tagClass && this.constructed == t.constructed && this.invalidTagNumber == t.invalidTagNumber;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getNumber() {
        return this.tagNumber;
    }

    public byte getClazz() {
        return this.tagClass;
    }

    public int toByteArray(byte[] buffer, int offset) {
        int i = 0;
        buffer[offset] = this.tagClass;
        if (this.constructed) {
            int n = offset;
            buffer[n] = (byte)(buffer[n] | 0x20);
        }
        if (this.tagNumber < 31 && !this.invalidTagNumber) {
            int n = offset++;
            buffer[n] = (byte)(buffer[n] | (byte)this.tagNumber);
        } else {
            int n = offset++;
            buffer[n] = (byte)(buffer[n] | 0x1F);
            for (i = (this.getSize() - 2) * 7; i > 0; i -= 7) {
                buffer[offset] = (byte)(0x80 | this.tagNumber >> i & 0x7F);
                ++offset;
            }
            buffer[offset] = (byte)(this.tagNumber & 0x7F);
            ++offset;
        }
        return offset;
    }

    public byte[] getBytes() {
        byte[] buffer = new byte[this.getSize()];
        this.toByteArray(buffer, 0);
        return buffer;
    }

    public int getSize() {
        if (this.tagNumber < 31 && !this.invalidTagNumber) {
            return 1;
        }
        if (this.tagNumber < 128) {
            return 2;
        }
        if (this.tagNumber < 16384) {
            return 3;
        }
        if (this.tagNumber < 0x200000) {
            return 4;
        }
        return 5;
    }

    public String toString() {
        if (this.tagClass == 0 && this.tagNumber < 31) {
            return UniversalText[this.tagNumber] + (this.constructed && this.tagNumber != 16 && this.tagNumber != 17 ? "*" : "");
        }
        String tagStr = HexString.hexifyByteArray(this.getBytes());
        return tagStr + " [ " + ClassText[this.tagClass >> 6 & 3] + " " + this.tagNumber + (this.constructed ? " ] IMPLICIT SEQUENCE" : " ]");
    }
}

