/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import de.cardcontact.opencard.service.InstructionCodeTable;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.tlv.HexString;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class APDUFormatter {
    public static String commandAPDUToString(CommandAPDU capdu) {
        StringBuffer sb = new StringBuffer(80);
        try {
            boolean extended = false;
            int len = capdu.getLength();
            byte[] buf = capdu.getBuffer();
            sb.append("C: ");
            sb.append(HexString.hexifyByteArray(buf, ' ', 4));
            sb.append(" - ");
            sb.append(InstructionCodeTable.instructionNameFromHeader(capdu.getBuffer()));
            int bodyoffset = 4;
            if ((len -= 4) > 0) {
                int l;
                int n = -1;
                if (buf[bodyoffset] == 0 && len > 1) {
                    if (len >= 3) {
                        n = ((buf[bodyoffset + 1] & 0xFF) << 8) + (buf[bodyoffset + 2] & 0xFF);
                        bodyoffset += 3;
                        len -= 3;
                        extended = true;
                    } else {
                        sb.append("Invalid extended length encoding for Lc\n");
                        sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                    }
                } else {
                    n = buf[bodyoffset] & 0xFF;
                    ++bodyoffset;
                    --len;
                }
                if (len > 0) {
                    sb.append(" Lc=" + n + " " + (extended ? "Extended" : "") + "\n");
                    if (n > len) {
                        n = len;
                    }
                    int ins = capdu.getByte(1);
                    if (capdu.getByte(0) == 0 && (ins == 32 || ins == 36 || ins == 44) || capdu.getByte(0) == 128 && ins == 82 && capdu.getByte(2) == 0) {
                        sb.append("      *** Sensitive Information Removed ***");
                    } else {
                        sb.append(HexString.dump(buf, bodyoffset, n, 16, 6));
                    }
                    bodyoffset += n;
                    len -= n;
                    n = -1;
                    if (len > 0) {
                        if (extended) {
                            if (len >= 2) {
                                n = ((buf[bodyoffset] & 0xFF) << 8) + (buf[bodyoffset + 1] & 0xFF);
                                bodyoffset += 2;
                                len -= 2;
                            } else {
                                sb.append("Invalid extended length encoding for Le\n");
                                sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                            }
                        } else {
                            n = buf[bodyoffset] & 0xFF;
                            ++bodyoffset;
                            --len;
                        }
                    }
                }
                if (n >= 0) {
                    sb.append("      Le=" + n + " " + (extended ? "Extended" : "") + "\n");
                }
                if (len > 0) {
                    sb.append("Unexpected bytes:\n");
                    sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                }
                if (sb.charAt(l = sb.length() - 1) == '\n') {
                    sb.deleteCharAt(l);
                }
            }
        }
        catch (Exception e) {
            return "Error decoding APDU: " + e.getMessage();
        }
        return sb.toString();
    }

    public static String responseAPDUToString(ResponseAPDU rapdu) {
        try {
            int l;
            StringBuffer sb = new StringBuffer(80);
            int len = rapdu.getLength();
            byte[] buf = rapdu.getBuffer();
            sb.append("   R: ");
            sb.append(StatusWordTable.MessageForSW(rapdu.sw()));
            sb.append(" Lr=" + (len - 2));
            sb.append("\n");
            if (len > 2) {
                sb.append(HexString.dump(buf, 0, len - 2, 16, 6));
            }
            if (sb.charAt(l = sb.length() - 1) == '\n') {
                sb.deleteCharAt(l);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Error decoding APDU: " + e.getMessage();
        }
    }
}

