/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.util.ArrayList;
import opencard.opt.security.KeyRef;

public class SmartCardHSMKey
implements KeyRef {
    private static final long serialVersionUID = -464439997111473313L;
    public static final String RSA = "RSA";
    public static final String EC = "EC";
    public static final String AES = "AES";
    private static final Tag tagUseCounter = new Tag(16, -128, false);
    private static final Tag tagAlgorithms = new Tag(17, -128, false);
    private static final Tag tagKeyDomainId = new Tag(18, -128, false);
    private byte keyRef;
    private String label;
    private byte[] keyId;
    private short keySize;
    private String algorithm;
    private byte[] algorithms;
    private long useCounter = -1L;
    private long reservedUses = 0L;
    private KeyDomain keyDomain;
    private SmartCardHSMCardService cardService;

    public SmartCardHSMKey(byte keyRef, String label, short keySize) {
        this(keyRef, label, keySize, RSA);
    }

    public SmartCardHSMKey(byte keyRef, String label, short keySize, String algorithm) {
        this.keyRef = keyRef;
        this.label = label;
        this.keySize = keySize;
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public byte getKeyRef() {
        return this.keyRef;
    }

    public void setKeyRef(byte keyRef) {
        this.keyRef = keyRef;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public void setKeyId(byte[] keyId) {
        this.keyId = keyId;
    }

    public short getKeySize() {
        return this.keySize;
    }

    public void setKeySize(short keySize) {
        this.keySize = keySize;
    }

    public void setAlgorithms(byte[] algorithms) {
        this.algorithms = algorithms;
    }

    public byte[] getAlgorithms() {
        return this.algorithms;
    }

    public void setKeyUseCounter(long useCounter) {
        this.useCounter = useCounter;
    }

    public boolean hasKeyUseCounter() {
        return this.useCounter != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUseCounter() {
        SmartCardHSMKey smartCardHSMKey = this;
        synchronized (smartCardHSMKey) {
            return this.useCounter - this.reservedUses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveKeyUse() {
        SmartCardHSMKey smartCardHSMKey = this;
        synchronized (smartCardHSMKey) {
            ++this.reservedUses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUseCounter() {
        SmartCardHSMKey smartCardHSMKey = this;
        synchronized (smartCardHSMKey) {
            --this.useCounter;
            if (this.reservedUses > 0L) {
                --this.reservedUses;
            }
        }
    }

    public void setKeyDomain(KeyDomain keyDomain) {
        this.keyDomain = keyDomain;
    }

    public KeyDomain getKeyDomain() {
        return this.keyDomain;
    }

    public void setCardService(SmartCardHSMCardService cardService) {
        this.cardService = cardService;
    }

    public SmartCardHSMCardService getCardService() {
        return this.cardService;
    }

    public void processKeyInfo(ArrayList<KeyDomain> keyDomains, byte[] a5) {
        try {
            ConstructedTLV a = new ConstructedTLV(a5);
            for (int i = 0; i < a.getElements(); ++i) {
                TLV t = a.get(i);
                if (t.getTag().equals(tagUseCounter)) {
                    byte[] val = t.getValue();
                    this.useCounter = (val[0] & 0xFF) << 8;
                    this.useCounter = (this.useCounter | (long)(val[1] & 0xFF)) << 8;
                    this.useCounter = (this.useCounter | (long)(val[2] & 0xFF)) << 8;
                    this.useCounter |= (long)(val[3] & 0xFF);
                    continue;
                }
                if (t.getTag().equals(tagAlgorithms)) {
                    this.algorithms = t.getValue();
                    continue;
                }
                if (!t.getTag().equals(tagKeyDomainId)) continue;
                this.keyDomain = keyDomains.get(t.getValue()[0] & 0xFF);
            }
        }
        catch (TLVEncodingException tLVEncodingException) {
            // empty catch block
        }
    }

    public String toString() {
        String str = "Label=" + this.label + ", KeyID=" + this.keyRef + ", Size=" + this.keySize + " bits";
        if (this.useCounter != -1L) {
            str = str + ", UseCounter=" + this.useCounter;
        }
        if (this.algorithms != null) {
            str = str + ", Algorithms=" + HexString.hexifyByteArray(this.algorithms, ':');
        }
        if (this.keyDomain != null) {
            str = str + ", KeyDomain=" + this.keyDomain.getId();
        }
        return str;
    }
}

