/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeySet;
import de.cardcontact.opencard.security.GPSCP03SecureChannel;
import de.cardcontact.opencard.security.GPSCPAuthenticator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;

public class GPSCP03Authenticator
extends GPSCPAuthenticator {
    private Mac aesCMAC;

    public GPSCP03Authenticator(byte[] hostChallenge) {
        super(hostChallenge);
        try {
            this.aesCMAC = Mac.getInstance("AESCMAC");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create cipher instance", e);
        }
    }

    @Override
    public void processInitializeUpdateResponse(byte[] rsp) throws OpenCardException {
        if (rsp.length != 29 && rsp.length != 32) {
            throw new CardServiceException("INITIALIZE UPDATE failed - wrong length of response data (" + rsp.length + ")");
        }
        this.keyDiversificationData = new byte[10];
        System.arraycopy(rsp, 0, this.keyDiversificationData, 0, this.keyDiversificationData.length);
        this.keyInformation = new byte[3];
        System.arraycopy(rsp, 10, this.keyInformation, 0, this.keyInformation.length);
        this.cardChallenge = new byte[8];
        System.arraycopy(rsp, 13, this.cardChallenge, 0, this.cardChallenge.length);
        this.cardCryptogram = new byte[8];
        System.arraycopy(rsp, 21, this.cardCryptogram, 0, this.cardCryptogram.length);
        if (rsp.length == 29) {
            this.sequenceCounter = new byte[0];
        } else {
            this.sequenceCounter = new byte[3];
            System.arraycopy(rsp, 29, this.sequenceCounter, 0, this.sequenceCounter.length);
        }
    }

    private byte[] deriveData(SecretKey key, byte ddc, int size, byte[] context) {
        ByteBuffer ob = ByteBuffer.allocate(256);
        int os = size;
        byte iter = 1;
        while (os > 0) {
            byte[] mac;
            ByteBuffer bb = ByteBuffer.allocate(256);
            bb.put(new byte[11]);
            bb.put(ddc);
            bb.put((byte)0);
            bb.put((byte)(size << 3 >> 8 & 0xFF));
            bb.put((byte)(size << 3 & 0xFF));
            bb.put(iter);
            bb.put(context);
            bb.flip();
            byte[] input = new byte[bb.remaining()];
            bb.get(input);
            try {
                this.aesCMAC.init(key);
                mac = this.aesCMAC.doFinal(input);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to calculate MAC", e);
            }
            int len = mac.length < os ? mac.length : os;
            ob.put(mac, 0, len);
            os -= len;
            iter = (byte)(iter + 1);
        }
        ob.flip();
        byte[] result = new byte[ob.remaining()];
        ob.get(result);
        return result;
    }

    @Override
    public void deriveSessionKeys(GPKeySet keys) {
        byte[] derivationParam = new byte[16];
        System.arraycopy(this.hostChallenge, 0, derivationParam, 0, 8);
        System.arraycopy(this.cardChallenge, 0, derivationParam, 8, 8);
        byte keylen = (byte)keys.getEncKey().getEncoded().length;
        byte[] res = this.deriveData(keys.getEncKey(), (byte)4, keylen, derivationParam);
        SecretKeySpec sessionEnc = new SecretKeySpec(res, "AES");
        res = this.deriveData(keys.getMacKey(), (byte)6, keylen, derivationParam);
        SecretKeySpec sessionMac = new SecretKeySpec(res, "AES");
        res = this.deriveData(keys.getMacKey(), (byte)7, keylen, derivationParam);
        SecretKeySpec sessionRMac = new SecretKeySpec(res, "AES");
        this.sessionKeys = new GPKeySet(keys.getVersion(), sessionEnc, sessionMac, sessionRMac, keys.getDekKey());
    }

    @Override
    public boolean isCardCryptogramValid() {
        byte[] context = new byte[16];
        System.arraycopy(this.hostChallenge, 0, context, 0, 8);
        System.arraycopy(this.cardChallenge, 0, context, 8, 8);
        byte[] mac = this.deriveData(this.sessionKeys.getMacKey(), (byte)0, 8, context);
        return Arrays.compare(this.cardCryptogram, mac) == 0;
    }

    @Override
    public byte[] calculateHostCryptogram(byte securityLevel) {
        byte[] mac;
        byte[] context = new byte[16];
        System.arraycopy(this.hostChallenge, 0, context, 0, 8);
        System.arraycopy(this.cardChallenge, 0, context, 8, 8);
        byte[] hostCryptogram = this.deriveData(this.sessionKeys.getMacKey(), (byte)1, 8, context);
        byte[] apdu = new byte[29];
        apdu[16] = -124;
        apdu[17] = -126;
        apdu[18] = securityLevel;
        apdu[19] = 0;
        apdu[20] = 16;
        System.arraycopy(hostCryptogram, 0, apdu, 21, 8);
        try {
            this.aesCMAC.init(this.sessionKeys.getMacKey());
            mac = this.aesCMAC.doFinal(apdu);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate MAC", e);
        }
        byte[] cryptogram = new byte[16];
        System.arraycopy(hostCryptogram, 0, cryptogram, 0, 8);
        System.arraycopy(mac, 0, cryptogram, 8, 8);
        this.secureChannel = new GPSCP03SecureChannel(this.sessionKeys.getEncKey(), this.sessionKeys.getMacKey(), this.sessionKeys.getRmacKey(), this.sessionKeys.getDekKey(), mac, securityLevel, "BC");
        return cryptogram;
    }
}

