/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.Extensions;
import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.util.Arrays;

public class CertificateBody
extends ConstructedTLV {
    static final Tag TAG = new Tag(78, 64, true);
    static final String NAME = "Certificate Body";
    static final Tag CPI_TAG = new Tag(41, 64, false);
    static final String CPI_NAME = "Certificate Profile Indicator";
    static final byte[] CPI_VALUE = new byte[]{0};
    static final byte[] CPI_VALUE_2 = new byte[]{16};
    boolean isRequest;
    boolean hasCAR;

    public CertificateBody(CertificationAuthorityReference car, PublicKeyTLV pub, CertificateHolderReference chr, CertificateHolderAuthorizationTemplate chat, CertificateEffectiveDate notBefore, CertificateExpirationDate notAfter) {
        super(TAG);
        this.setName(NAME);
        PrimitiveTLV t = new PrimitiveTLV(CPI_TAG, CPI_VALUE);
        t.setName(CPI_NAME);
        this.isRequest = false;
        this.add(t);
        this.add(car);
        this.add(pub);
        this.add(chr);
        this.add(chat);
        this.add(notBefore);
        this.add(notAfter);
    }

    public CertificateBody(CertificationAuthorityReference car, PublicKeyTLV pub, CertificateHolderReference chr) {
        super(TAG);
        this.setName(NAME);
        PrimitiveTLV t = new PrimitiveTLV(CPI_TAG, CPI_VALUE);
        t.setName(CPI_NAME);
        this.isRequest = true;
        this.add(t);
        if (car != null) {
            this.add(car);
        }
        this.add(pub);
        this.add(chr);
    }

    public CertificateBody(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certificate Body with wrong tag " + String.valueOf(tlv.getTag()));
        }
        this.setName(NAME);
        this.isRequest = this.childs.size() < 7;
        int i = 0;
        TLV t = (TLV)this.childs.get(i);
        if (!t.getTag().equals(CPI_TAG)) {
            throw new TLVEncodingException("Certificate Profile Indicator with wrong tag " + String.valueOf(t.getTag()));
        }
        if (!Arrays.equals(CPI_VALUE, t.getValue()) && !Arrays.equals(CPI_VALUE_2, t.getValue())) {
            throw new TLVEncodingException("Certificate Profile Indicator unsupported version");
        }
        t.setName(CPI_NAME);
        if (((TLV)this.childs.get(++i)).getTag().equals(CertificationAuthorityReference.TAG)) {
            this.childs.set(i, new CertificationAuthorityReference((TLV)this.childs.get(i)));
            this.hasCAR = true;
            ++i;
        }
        this.childs.set(i, PublicKeyTLV.newPublicKey((TLV)this.childs.get(i)));
        this.childs.set(++i, new CertificateHolderReference((TLV)this.childs.get(i)));
        if (!this.isRequest) {
            this.childs.set(++i, new CertificateHolderAuthorizationTemplate((TLV)this.childs.get(i)));
            this.childs.set(++i, new CertificateEffectiveDate((TLV)this.childs.get(i)));
            this.childs.set(++i, new CertificateExpirationDate((TLV)this.childs.get(i)));
        }
        if (++i < this.childs.size()) {
            this.childs.set(i, new Extensions((TLV)this.childs.get(i)));
        }
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        if (!this.hasCAR) {
            return null;
        }
        return (CertificationAuthorityReference)this.childs.get(1);
    }

    public PublicKeyTLV getPublicKeyTLV() {
        return (PublicKeyTLV)this.childs.get(this.hasCAR ? 2 : 1);
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return (CertificateHolderReference)this.childs.get(this.hasCAR ? 3 : 2);
    }

    public CertificateHolderAuthorizationTemplate getCertificateHolderAuthorizationTemplate() {
        if (this.isRequest) {
            throw new RuntimeException("Certificate body in request does not have an holder authorization template");
        }
        return (CertificateHolderAuthorizationTemplate)this.childs.get(this.hasCAR ? 4 : 3);
    }

    public CertificateEffectiveDate getCertificateEffectiveDate() {
        if (this.isRequest) {
            throw new RuntimeException("Certificate body in request does not have an effective date");
        }
        return (CertificateEffectiveDate)this.childs.get(this.hasCAR ? 5 : 4);
    }

    public CertificateExpirationDate getCertificateExpirationDate() {
        if (this.isRequest) {
            throw new RuntimeException("Certificate body in request does not have an expiration date");
        }
        return (CertificateExpirationDate)this.childs.get(this.hasCAR ? 6 : 5);
    }

    public Extensions getExtensions() {
        int i = (this.isRequest ? 3 : 6) + (this.hasCAR ? 1 : 0);
        if (i >= this.childs.size()) {
            return null;
        }
        return (Extensions)this.childs.get(i);
    }
}

