/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class ECPublicKeyTLV
extends PublicKeyTLV {
    public static final ObjectIdentifier id_TA_ECDSA_SHA_1 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 1});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_224 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 2});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_256 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 3});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_384 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 4});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_512 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 5});
    static final Tag TAG_P = new Tag(1, -128, false);
    static final Tag TAG_A = new Tag(2, -128, false);
    static final Tag TAG_B = new Tag(3, -128, false);
    static final Tag TAG_G = new Tag(4, -128, false);
    static final Tag TAG_R = new Tag(5, -128, false);
    static final Tag TAG_Y = new Tag(6, -128, false);
    static final Tag TAG_F = new Tag(7, -128, false);
    static final String NAME_P = "Prime";
    static final String NAME_A = "First Coefficient";
    static final String NAME_B = "Second Coefficient";
    static final String NAME_G = "Base Point";
    static final String NAME_R = "Order of the Base Point";
    static final String NAME_Y = "Public Point";
    static final String NAME_F = "Cofactor";
    public static final byte[] OID_prime192v3 = new byte[]{42, -122, 72, -50, 61, 3, 1, 3};
    public static final byte[] OID_prime192v2 = new byte[]{42, -122, 72, -50, 61, 3, 1, 2};
    public static final byte[] OID_prime192v1 = new byte[]{42, -122, 72, -50, 61, 3, 1, 1};
    public static final byte[] OID_prime256v1 = new byte[]{42, -122, 72, -50, 61, 3, 1, 7};
    public static final byte[] OID_prime239v3 = new byte[]{42, -122, 72, -50, 61, 3, 1, 6};
    public static final byte[] OID_prime239v2 = new byte[]{42, -122, 72, -50, 61, 3, 1, 5};
    public static final byte[] OID_prime239v1 = new byte[]{42, -122, 72, -50, 61, 3, 1, 4};
    public static final byte[] OID_secp256k1 = new byte[]{43, -127, 4, 0, 10};
    public static final byte[] OID_secp521r1 = new byte[]{43, -127, 4, 0, 35};
    public static final byte[] OID_secp384r1 = new byte[]{43, -127, 4, 0, 34};
    public static final byte[] OID_secp224r1 = new byte[]{43, -127, 4, 0, 33};
    public static final byte[] OID_secp192k1 = new byte[]{43, -127, 4, 0, 31};
    public static final byte[] OID_brainpoolP224t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 6};
    public static final byte[] OID_brainpoolP512t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 14};
    public static final byte[] OID_brainpoolP224r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 5};
    public static final byte[] OID_brainpoolP512r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 13};
    public static final byte[] OID_brainpoolP192t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 4};
    public static final byte[] OID_brainpoolP384t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 12};
    public static final byte[] OID_brainpoolP192r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 3};
    public static final byte[] OID_brainpoolP384r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 11};
    public static final byte[] OID_brainpoolP160t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 2};
    public static final byte[] OID_brainpoolP320t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 10};
    public static final byte[] OID_brainpoolP160r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 1};
    public static final byte[] OID_brainpoolP320r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 9};
    public static final byte[] OID_brainpoolP256t1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 8};
    public static final byte[] OID_brainpoolP256r1 = new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 7};

    public static byte[] encodePoint(ECPoint point, int size) {
        byte[] encoded = new byte[(size << 1) + 1];
        encoded[0] = 4;
        PublicKeyTLV.toUnsignedByteArray(point.getAffineX(), encoded, 1, size);
        PublicKeyTLV.toUnsignedByteArray(point.getAffineY(), encoded, 1 + size, size);
        return encoded;
    }

    public static ECPoint decodePoint(byte[] point) {
        int size = point.length - 1 >> 1;
        byte[] xbin = new byte[size];
        byte[] ybin = new byte[size];
        System.arraycopy(point, 1, xbin, 0, size);
        System.arraycopy(point, 1 + size, ybin, 0, size);
        BigInteger x = new BigInteger(1, xbin);
        BigInteger y = new BigInteger(1, ybin);
        return new ECPoint(x, y);
    }

    public ECPublicKeyTLV(ObjectIdentifier oid, ECPublicKey pk, boolean withDomainParameter) {
        super(oid);
        PrimitiveTLV t;
        ECParameterSpec param = pk.getParams();
        EllipticCurve curve = param.getCurve();
        int keysize = curve.getField().getFieldSize();
        keysize = keysize + 7 >> 3;
        ECFieldFp field = (ECFieldFp)curve.getField();
        if (withDomainParameter) {
            t = new PrimitiveTLV(TAG_P, PublicKeyTLV.toUnsignedByteArray(field.getP(), keysize));
            t.setName(NAME_P);
            this.add(t);
            t = new PrimitiveTLV(TAG_A, PublicKeyTLV.toUnsignedByteArray(curve.getA(), keysize));
            t.setName(NAME_A);
            this.add(t);
            t = new PrimitiveTLV(TAG_B, PublicKeyTLV.toUnsignedByteArray(curve.getB(), keysize));
            t.setName(NAME_B);
            this.add(t);
            t = new PrimitiveTLV(TAG_G, ECPublicKeyTLV.encodePoint(param.getGenerator(), keysize));
            t.setName(NAME_G);
            this.add(t);
            t = new PrimitiveTLV(TAG_R, PublicKeyTLV.toUnsignedByteArray(param.getOrder(), keysize));
            t.setName(NAME_R);
            this.add(t);
        }
        t = new PrimitiveTLV(TAG_Y, ECPublicKeyTLV.encodePoint(pk.getW(), keysize));
        t.setName(NAME_Y);
        this.add(t);
        if (withDomainParameter) {
            t = new PrimitiveTLV(TAG_F, new byte[]{(byte)param.getCofactor()});
            t.setName(NAME_F);
            this.add(t);
        }
    }

    public ECPublicKeyTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        TLV t;
        int size = this.childs.size();
        if (size != 2 && size != 8) {
            throw new TLVEncodingException("Public Key must contain 2 or 8 elements");
        }
        int i = 0;
        if (this.hasDomainParameter()) {
            if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_P)) {
                throw new TLVEncodingException("Expected Prime in Public Key");
            }
            t.setName(NAME_P);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_A)) {
                throw new TLVEncodingException("Expected First Coefficient in Public Key");
            }
            t.setName(NAME_A);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_B)) {
                throw new TLVEncodingException("Expected Second Coefficient in Public Key");
            }
            t.setName(NAME_B);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_G)) {
                throw new TLVEncodingException("Expected Base Point in Public Key");
            }
            t.setName(NAME_G);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_R)) {
                throw new TLVEncodingException("Expected Order of the Base Point in Public Key");
            }
            t.setName(NAME_R);
        }
        if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_Y)) {
            throw new TLVEncodingException("Expected Public Point in Public Key");
        }
        t.setName(NAME_Y);
        if (this.hasDomainParameter()) {
            if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_F)) {
                throw new TLVEncodingException("Expected Cofactor in Public Key");
            }
            t.setName(NAME_F);
        }
    }

    public boolean hasDomainParameter() {
        return this.childs.size() == 8;
    }

    public byte[] getCurveOID() {
        if (!this.hasDomainParameter()) {
            throw new RuntimeException("EC public key does not have domain parameter");
        }
        byte[] p = ((TLV)this.childs.get(1)).getValue();
        byte[] a = ((TLV)this.childs.get(2)).getValue();
        byte[] b = ((TLV)this.childs.get(3)).getValue();
        int fp = ((p[p.length - 1] & 0xFF) << 16) + ((a[a.length - 1] & 0xFF) << 8) + (b[b.length - 1] & 0xFF);
        switch (fp) {
            case 16776214: {
                return OID_prime192v3;
            }
            case 16776275: {
                return OID_prime192v2;
            }
            case 16776369: {
                return OID_prime192v1;
            }
            case 16776267: {
                return OID_prime256v1;
            }
            case 16776254: {
                return OID_prime239v3;
            }
            case 0xFFFC2C: {
                return OID_prime239v2;
            }
            case 16776202: {
                return OID_prime239v1;
            }
            case 3080199: {
                return OID_secp256k1;
            }
            case 0xFFFC00: {
                return OID_secp521r1;
            }
            case 0xFFFCEF: {
                return OID_secp384r1;
            }
            case 130740: {
                return OID_secp224r1;
            }
            case 0x370003: {
                return OID_secp192k1;
            }
            case 16776333: {
                return OID_brainpoolP224t1;
            }
            case 15986750: {
                return OID_brainpoolP512t1;
            }
            case 16728843: {
                return OID_brainpoolP224r1;
            }
            case 15976995: {
                return OID_brainpoolP512r1;
            }
            case 0x979479: {
                return OID_brainpoolP192t1;
            }
            case 5460206: {
                return OID_brainpoolP384t1;
            }
            case 9957321: {
                return OID_brainpoolP192r1;
            }
            case 5449233: {
                return OID_brainpoolP384r1;
            }
            case 986240: {
                return OID_brainpoolP160t1;
            }
            case 2565203: {
                return OID_brainpoolP320t1;
            }
            case 983128: {
                return OID_brainpoolP160r1;
            }
            case 2602150: {
                return OID_brainpoolP320r1;
            }
            case 0x777404: {
                return OID_brainpoolP256t1;
            }
            case 7854518: {
                return OID_brainpoolP256r1;
            }
        }
        return null;
    }

    public PublicKey getPublicKey(ECParameterSpec params, String providerName) {
        int i = 6;
        if (this.hasDomainParameter()) {
            ECFieldFp field = new ECFieldFp(new BigInteger(1, ((TLV)this.childs.get(1)).getValue()));
            EllipticCurve curve = new EllipticCurve(field, new BigInteger(1, ((TLV)this.childs.get(2)).getValue()), new BigInteger(1, ((TLV)this.childs.get(3)).getValue()));
            ECPoint g = ECPublicKeyTLV.decodePoint(((TLV)this.childs.get(4)).getValue());
            BigInteger r = new BigInteger(1, ((TLV)this.childs.get(5)).getValue());
            byte f = ((TLV)this.childs.get(7)).getValue()[0];
            params = new ECParameterSpec(curve, g, r, f);
        } else {
            if (params == null) {
                throw new RuntimeException("EC public key does not have domain parameter");
            }
            i = 1;
        }
        ECPoint y = ECPublicKeyTLV.decodePoint(((TLV)this.childs.get(i)).getValue());
        ECPublicKeySpec spec = new ECPublicKeySpec(y, params);
        KeyFactory fact = null;
        PublicKey key = null;
        try {
            if (providerName == null && !"Android Runtime".equals(System.getProperty("java.runtime.name")) && Security.getProvider("BC") != null) {
                providerName = "BC";
            }
            fact = providerName != null ? KeyFactory.getInstance("EC", providerName) : KeyFactory.getInstance("EC");
            key = fact.generatePublic(spec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating public key", e);
        }
        return key;
    }

    @Override
    public PublicKey getPublicKey(AlgorithmParameterSpec params) {
        return this.getPublicKey((ECParameterSpec)params, null);
    }

    @Override
    public byte[] getEncodedForSPKI() {
        int i = this.hasDomainParameter() ? 6 : 1;
        return ((TLV)this.childs.get(i)).getValue();
    }
}

