/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import java.util.Arrays;

public class KeyDomain {
    private byte id;
    private boolean isCreated = false;
    private byte shares;
    private byte outstanding;
    private byte[] kcv;
    private byte[] keyDomainUID;

    public KeyDomain(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public byte getShares() {
        return this.shares;
    }

    public byte getOutstanding() {
        return this.outstanding;
    }

    public byte[] getKcv() {
        return this.kcv;
    }

    public byte[] getKeyDomainUID() {
        if (this.keyDomainUID != null) {
            return this.keyDomainUID;
        }
        return this.kcv;
    }

    public void update(byte[] status) {
        if (status == null || status.length == 0) {
            this.isCreated = false;
            this.kcv = null;
            this.keyDomainUID = null;
            return;
        }
        this.isCreated = true;
        this.shares = status[0];
        this.outstanding = status[1];
        this.kcv = new byte[8];
        System.arraycopy(status, 2, this.kcv, 0, this.kcv.length);
        if (status.length > 10) {
            this.keyDomainUID = new byte[status.length - 10];
            System.arraycopy(status, 10, this.keyDomainUID, 0, this.keyDomainUID.length);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyDomain)) {
            return false;
        }
        KeyDomain kd = (KeyDomain)obj;
        if (this.keyDomainUID != null) {
            if (kd.keyDomainUID == null) {
                return false;
            }
            return Arrays.equals(this.keyDomainUID, kd.keyDomainUID);
        }
        return this.kcv != null && Arrays.equals(this.kcv, kd.kcv);
    }
}

