/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardWaiter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.APDUTracer;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.SystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartCard {
    private static final String VERSION = "OCF1.2;IBM Reference Implementation with OpenSCDP extensions ";
    private static final Logger logger = LoggerFactory.getLogger(SmartCard.class);
    private CardServiceScheduler scheduler = null;
    private CardID cid = null;
    private CardChannel mutexCardChannel = null;
    private APDUTracer aPDUTracer = null;
    private static boolean OCFisStarted = false;
    private Vector allocatedCS = new Vector();
    private static Vector smartCardCache = new Vector();
    private static int refCount_ = 0;

    public static String getVersion() {
        Package p = SmartCard.class.getPackage();
        if (p.getSpecificationVersion() == null || p.getImplementationVersion() == null) {
            return "OCF1.2;IBM Reference Implementation with OpenSCDP extensions (Unknown Version)";
        }
        return VERSION + p.getSpecificationVersion() + "." + p.getImplementationVersion();
    }

    public SmartCard(CardServiceScheduler scheduler, CardID cid) {
        logger.debug("[init] scheduler " + scheduler + ", cid " + cid);
        this.scheduler = scheduler;
        this.cid = cid;
    }

    private void assertSmartCardOpen() {
        try {
            if (!this.scheduler.isAlive()) {
                throw new OpenCardRuntimeException("SmartCard closed");
            }
        }
        catch (CardTerminalException e) {
            throw new OpenCardRuntimeException("SmartCard closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMutex() throws InterruptedException, CardTerminalException {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            logger.debug("[beginMutex] entry " + this);
            this.assertSmartCardOpen();
            this.mutexCardChannel = this.scheduler.allocateCardChannel(this, true);
            if (this.mutexCardChannel == null) {
                throw new InterruptedException("beginMutex");
            }
            Enumeration css = this.allocatedCS.elements();
            while (css.hasMoreElements()) {
                CardService cs = (CardService)css.nextElement();
                cs.setCardChannel(this.mutexCardChannel);
            }
            logger.debug("[beginMutex] exit " + this);
        }
    }

    public synchronized void close() throws CardTerminalException {
        if (this.scheduler != null) {
            logger.debug("[close] SmartCard closing");
            if (this.mutexCardChannel != null) {
                this.endMutex();
            }
            this.scheduler.releaseSmartCard(this);
            this.scheduler = null;
        }
        smartCardCache.removeElement(this);
    }

    private static void configureServiceRegistry() throws CardServiceException {
        CardServiceRegistry serviceRegistry = CardServiceRegistry.getRegistry();
        StringTokenizer recordTokenizer = SmartCard.getRegistryEntry("OpenCard.services");
        if (recordTokenizer != null) {
            StringBuffer message = new StringBuffer();
            while (recordTokenizer.hasMoreElements()) {
                String factoryName = (String)recordTokenizer.nextElement();
                try {
                    Class<?> factoryClass = Class.forName(factoryName);
                    serviceRegistry.add((CardServiceFactory)factoryClass.newInstance());
                }
                catch (ClassNotFoundException cnfe) {
                    logger.error("[configureServiceRegistry]" + cnfe.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" not found");
                }
                catch (InstantiationException ie) {
                    logger.error("[configureServiceRegistry]" + ie.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" not instantiatable");
                }
                catch (IllegalAccessException iae) {
                    logger.error("[configureServiceRegistry]" + iae.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" constructor not accessible");
                }
            }
            if (message.length() > 0) {
                throw new CardServiceException(message.toString());
            }
        } else {
            logger.debug("[configureServiceRegistry]no services entry in properties");
        }
    }

    private static void configureTerminalRegistry() throws ClassNotFoundException, CardTerminalException {
        CardTerminalRegistry d_terminalRegistry = CardTerminalRegistry.getRegistry();
        StringTokenizer recordTokenizer = SmartCard.getRegistryEntry("OpenCard.terminals");
        Hashtable factories = new Hashtable();
        if (recordTokenizer != null) {
            while (recordTokenizer.hasMoreElements()) {
                String record = (String)recordTokenizer.nextElement();
                SmartCard.handleTerminalFactoryEntries(record, factories, d_terminalRegistry);
            }
        } else {
            logger.debug("[configureTerminalRegistry]no terminals in properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endMutex() {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            logger.debug("[endMutex] entry " + this);
            this.assertSmartCardOpen();
            this.scheduler.releaseCardChannel(this.mutexCardChannel);
            this.mutexCardChannel = null;
            Enumeration css = this.allocatedCS.elements();
            while (css.hasMoreElements()) {
                CardService cs = (CardService)css.nextElement();
                cs.setCardChannel(null);
            }
            logger.debug("[endMutex] exit " + this);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (CardTerminalException ctx) {
            logger.error("[finalize]" + ctx.toString());
        }
    }

    public CardID getCardID() {
        return this.cid;
    }

    public CardService getCardService(Class clazz, boolean block) throws ClassNotFoundException, CardServiceException {
        CardService cs = null;
        logger.debug("[getCardService] (" + clazz + ")");
        this.assertSmartCardOpen();
        cs = CardServiceRegistry.getRegistry().getCardServiceInstance(clazz, this.cid, this.scheduler, this, block);
        if (this.mutexCardChannel != null && this.mutexCardChannel.isOpen()) {
            cs.setCardChannel(this.mutexCardChannel);
        }
        this.allocatedCS.addElement(cs);
        logger.debug("[getCardService] " + this.allocatedCS.size() + " elements in cache");
        return cs;
    }

    private static StringTokenizer getRegistryEntry(String tag) {
        String registryProps = SystemAccess.getSystemAccess().getProperty(tag);
        logger.debug("[getRegistryEntry] tag " + tag + " = " + registryProps);
        return registryProps != null ? new StringTokenizer(registryProps) : null;
    }

    @Deprecated
    public static SmartCard getSmartCard(CardTerminalEvent ctEvent) throws CardTerminalException {
        return SmartCard.getSmartCard(ctEvent, null, null);
    }

    public static SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req) throws CardTerminalException {
        return SmartCard.getSmartCard(ctEvent, req, null);
    }

    public static SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req, Object lockHandle) throws CardTerminalException {
        SmartCard newCard = CardServiceRegistry.getRegistry().getSmartCard(ctEvent, req, lockHandle);
        if (newCard != null) {
            smartCardCache.addElement(newCard);
            logger.debug("[getSmartCard]" + smartCardCache.size() + " elements in cache");
        }
        return newCard;
    }

    private static void handleTerminalFactoryEntries(String record, Hashtable factories, CardTerminalRegistry terminalRegistry) throws ClassNotFoundException, CardTerminalException {
        CardTerminalFactory aFactory = null;
        String[] params = null;
        StringTokenizer elementTokenizer = new StringTokenizer(record, "|");
        int elements = elementTokenizer.countTokens();
        if (elements > 0) {
            params = new String[elements - 1];
            int counter = 0;
            String factoryName = null;
            while (elementTokenizer.hasMoreElements()) {
                if (counter == 0) {
                    factoryName = (String)elementTokenizer.nextElement();
                } else {
                    params[counter - 1] = (String)elementTokenizer.nextElement();
                }
                ++counter;
            }
            aFactory = (CardTerminalFactory)factories.get(factoryName);
            if (aFactory == null) {
                try {
                    Class<?> factoryClass = Class.forName(factoryName);
                    aFactory = (CardTerminalFactory)factoryClass.newInstance();
                    factories.put(factoryName, aFactory);
                }
                catch (InstantiationException ie) {
                    throw new CardTerminalException(ie.toString());
                }
                catch (IllegalAccessException iae) {
                    throw new CardTerminalException(iae.toString());
                }
            }
            aFactory.createCardTerminals(terminalRegistry, params);
        }
    }

    public static boolean isStarted() {
        return OCFisStarted;
    }

    public static void shutdown() throws CardTerminalException {
        logger.debug("[shutdown] shutdown OpenCard");
        if (--refCount_ == 0) {
            while (!smartCardCache.isEmpty()) {
                ((SmartCard)smartCardCache.firstElement()).close();
            }
            CardTerminalRegistry terminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration terminals = terminalRegistry.getCardTerminals();
            while (terminals.hasMoreElements()) {
                terminalRegistry.remove((CardTerminal)terminals.nextElement());
            }
            CardServiceRegistry serviceRegistry = CardServiceRegistry.getRegistry();
            for (CardServiceFactory serviceFactory : serviceRegistry.getCardServiceFactories()) {
                serviceRegistry.remove(serviceFactory);
            }
            EventGenerator.getGenerator().removeAllCTListener();
            EventGenerator.getGenerator().removeAllPollables();
            OCFisStarted = false;
        }
    }

    public static synchronized void start() throws OpenCardPropertyLoadingException, ClassNotFoundException, CardServiceException, CardTerminalException {
        if (!OCFisStarted) {
            logger.debug("[start] startup opencard");
            String loaderClassName = SystemAccess.getSystemAccess().getProperty("OpenCard.loaderClassName", "opencard.opt.util.OpenCardPropertyFileLoader");
            if (loaderClassName != null && loaderClassName.length() > 0) {
                logger.debug("[start] use loader class: " + loaderClassName);
                try {
                    Class<?> loaderClass = Class.forName(loaderClassName);
                    OpenCardConfigurationProvider loader = (OpenCardConfigurationProvider)loaderClass.newInstance();
                    loader.loadProperties();
                    logger.debug("[start] loader loaded properties: ");
                }
                catch (InstantiationException ie) {
                    throw new CardServiceOperationFailedException(ie.toString());
                }
                catch (IllegalAccessException iae) {
                    throw new CardServiceOperationFailedException(iae.toString());
                }
            } else {
                logger.debug("[start] did not use a loader class!");
            }
            EventGenerator.getGenerator();
            SmartCard.configureTerminalRegistry();
            SmartCard.configureServiceRegistry();
            OCFisStarted = true;
        } else {
            logger.debug("[start] already configured");
        }
        ++refCount_;
        logger.debug("[start] finished");
    }

    public static synchronized void startup() throws OpenCardPropertyLoadingException, ClassNotFoundException, CardServiceException, CardTerminalException {
        if (!OCFisStarted) {
            logger.debug("[start] startup opencard");
            EventGenerator.getGenerator();
            OCFisStarted = true;
        } else {
            logger.debug("[start] already configured");
        }
        ++refCount_;
        logger.debug("[start] finished");
    }

    public static SmartCard waitForCard(CardRequest req) throws CardTerminalException {
        return SmartCard.waitForCard(req, null);
    }

    public static SmartCard waitForCard(CardRequest req, Object lockHandle) throws CardTerminalException {
        logger.debug("[waitForCard] passing request " + req + " to CardServiceRegistry");
        CardWaiter cardWaiter = new CardWaiter(req, lockHandle);
        SmartCard newCard = cardWaiter.waitForCard();
        if (newCard != null) {
            logger.debug("[waitForCard]" + smartCardCache.size() + " elements in cache");
        }
        return newCard;
    }

    public CardID reset(boolean warm) throws CardTerminalException {
        this.cid = this.scheduler.reset(null, warm, false);
        return this.cid;
    }

    public void setAPDUTracer(APDUTracer tracer) {
        this.aPDUTracer = tracer;
        this.scheduler.getSlotChannel().setAPDUTracer(tracer);
    }

    public APDUTracer getAPDUTracer() {
        return this.aPDUTracer;
    }
}

