/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.PrimaryCardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CardServiceRegistry.class);
    private static final CardServiceRegistry registry = new CardServiceRegistry();
    private List<CardServiceFactory> factories = new CopyOnWriteArrayList<CardServiceFactory>();
    private Hashtable slot2channel = new Hashtable();

    private CardServiceRegistry() {
        logger.debug("[init] instantiating");
    }

    public void add(CardServiceFactory factory) {
        logger.debug("[add] " + factory);
        if (!this.factories.contains(factory)) {
            this.factories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardServiceScheduler allocateCardServiceScheduler(SlotChannel channel) throws CardTerminalException {
        CardServiceScheduler scheduler = null;
        SlotChannel slotChannel = channel;
        synchronized (slotChannel) {
            scheduler = (CardServiceScheduler)channel.getScheduler();
            if (scheduler == null) {
                logger.debug("[allocateCardServiceScheduler] instantiating CardServiceScheduler");
                scheduler = new CardServiceScheduler(channel);
                channel.setScheduler(scheduler);
                for (CardServiceFactory factory : this.factories) {
                    if (!(factory instanceof PrimaryCardServiceFactory)) continue;
                    logger.debug("[allocateCardServiceScheduler] setting up card via PrimaryCardServiceFactory" + factory);
                    ((PrimaryCardServiceFactory)((Object)factory)).setupSmartCard(channel);
                    break;
                }
            }
        }
        return scheduler;
    }

    protected Class getCardServiceClassFor(Class clazz, CardID cid, CardServiceScheduler scheduler) {
        logger.debug("[getCardServiceClass] for " + clazz + " and " + cid);
        for (CardServiceFactory factory : this.factories) {
            logger.debug("[getCardServiceClass] checking " + factory);
            CardType type = scheduler.getCardTypeFor(factory);
            if (type == null) {
                try {
                    type = factory.getCardType(cid, scheduler);
                    scheduler.setCardTypeFor(factory, type);
                }
                catch (CardTerminalException t) {
                    logger.debug("[getCardServiceClass]" + t);
                    t.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == type) continue;
            Class cardServiceClass = factory.getClassFor(clazz, type);
            logger.debug("[getCardServiceClass] factory " + factory + " produced " + cardServiceClass);
            if (cardServiceClass == null) continue;
            return cardServiceClass;
        }
        logger.info("[getCardServiceClass] no CardService for " + clazz);
        return null;
    }

    public final List<CardServiceFactory> getCardServiceFactories() {
        return this.factories;
    }

    protected CardService getCardServiceInstance(Class clazz, CardID cid, CardServiceScheduler scheduler, SmartCard card, boolean block) throws ClassNotFoundException {
        logger.debug("[getCardServiceInstance] for " + clazz + " from " + card);
        for (CardServiceFactory factory : this.factories) {
            logger.debug("[getCardServiceInstance] checking " + factory);
            CardType type = scheduler.getCardTypeFor(factory);
            if (type == null) {
                try {
                    type = factory.getCardType(cid, scheduler);
                    scheduler.setCardTypeFor(factory, type);
                }
                catch (CardTerminalException t) {
                    logger.debug("[getCardServiceInstance]" + t);
                    t.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == type) continue;
            try {
                CardService service = factory.getCardServiceInstance(clazz, type, scheduler, card, block);
                logger.debug("[getCardServiceInstance] factory " + factory + " produced " + service);
                if (service == null) continue;
                return service;
            }
            catch (CardServiceException csx) {
                logger.info("[getCardServiceInstance] factory " + factory + " failed: " + csx);
            }
        }
        logger.info("[getCardServiceInstance] no CardService for " + clazz + " found");
        throw new ClassNotFoundException("CardService implementing " + clazz.toString());
    }

    public static CardServiceRegistry getRegistry() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req, Object lockHandle) throws CardTerminalException {
        logger.debug("[getSmartCard] CTEvent " + ctEvent);
        boolean newScheduler = false;
        CardTerminal terminal = (CardTerminal)ctEvent.getSource();
        SlotChannel channel = null;
        int slotID = ctEvent.getSlotID();
        CardID cid = terminal.getCardID(slotID);
        Integer hashCode = new Integer(terminal.hashCode() + slotID);
        Hashtable hashtable = this.slot2channel;
        synchronized (hashtable) {
            channel = (SlotChannel)this.slot2channel.get(hashCode);
            if (channel != null && channel.getLockHandle() == lockHandle) {
                logger.debug("[getSmartCard] secondary waitForCard(); don't need to open SlotChannel again");
            } else {
                channel = terminal.openSlotChannel(slotID, lockHandle);
                this.slot2channel.put(hashCode, channel);
            }
        }
        CardServiceScheduler scheduler = (CardServiceScheduler)channel.getScheduler();
        if (scheduler == null) {
            scheduler = this.allocateCardServiceScheduler(channel);
            newScheduler = true;
        }
        if (req != null && !this.isCardRequestSatisfied(req, cid, terminal, scheduler)) {
            logger.info("[getSmartCard] CardRequest " + req + " cannot be satisfied with " + cid);
            if (newScheduler) {
                scheduler.closeDown();
            }
            return null;
        }
        logger.debug("[getSmartCard] using CardServiceScheduler " + scheduler);
        return scheduler.createSmartCard(cid);
    }

    private boolean isCardRequestSatisfied(CardRequest req, CardID cid, CardTerminal terminal, CardServiceScheduler scheduler) {
        CardIDFilter filter = req.getFilter();
        if (filter != null && !filter.isCandidate(cid)) {
            logger.info("[isCardRequestSatisfied] filtered out by " + filter);
            return false;
        }
        if (req.getCardTerminal() != null && req.getCardTerminal() != terminal) {
            logger.info("[isCardRequestSatisfied]requested terminal " + req.getCardTerminal() + " does not match receiving terminal " + terminal);
            return false;
        }
        if (req.getCardServiceClass() != null && this.getCardServiceClassFor(req.getCardServiceClass(), cid, scheduler) == null) {
            logger.info("[isCardRequestSatisfied]requested CardService class " + req.getCardServiceClass() + " not supported for  " + cid);
            return false;
        }
        return true;
    }

    protected void releaseScheduler(CardServiceScheduler scheduler) {
        int hashCode = scheduler.getSlotChannel().getCardTerminal().hashCode() + scheduler.getSlotChannel().getSlotNumber();
        this.slot2channel.remove(hashCode);
    }

    public void remove(CardServiceFactory factory) {
        logger.debug("[remove] " + factory);
        this.factories.remove(factory);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        for (CardServiceFactory factory : this.factories) {
            sb.append("++ registered factory ").append(factory).append("\n");
        }
        return sb.toString();
    }
}

