/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeyProvider;
import de.cardcontact.opencard.security.GPKeySet;
import java.util.HashMap;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;

public class GPKeyProviderDefault
implements GPKeyProvider {
    HashMap<Integer, GPKeySet> keyMap = new HashMap();

    private static Integer mapKeyFor(byte scp, byte version) {
        return (scp << 8) + (version & 0xFF);
    }

    public void addKey(byte scp, GPKeySet keys) {
        this.keyMap.put(GPKeyProviderDefault.mapKeyFor(scp, keys.getVersion()), keys);
    }

    @Override
    public GPKeySet getGPKeys(byte scp, byte version, byte[] derivationData) throws OpenCardException {
        GPKeySet gkp = this.keyMap.get(GPKeyProviderDefault.mapKeyFor(scp, version));
        if (gkp == null) {
            throw new CardServiceException("Could not locate key for protocol " + scp + " in version " + version);
        }
        return gkp;
    }
}

