/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeyDerivation;
import de.cardcontact.opencard.security.GPKeySet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;

public abstract class AESKeyDerivationBase
extends GPKeyDerivation {
    int keysize = 16;

    protected abstract byte[] calculateMAC(byte[] var1);

    public byte[] deriveData(byte ddc, int size, byte[] context) {
        ByteBuffer ob = ByteBuffer.allocate(256);
        int os = size;
        byte iter = 1;
        while (os > 0) {
            ByteBuffer bb = ByteBuffer.allocate(256);
            bb.put(iter);
            bb.put(new byte[3]);
            bb.put(ddc);
            bb.put((byte)0);
            bb.put(context);
            bb.flip();
            byte[] input = new byte[bb.remaining()];
            bb.get(input);
            byte[] mac = this.calculateMAC(input);
            int len = mac.length < os ? mac.length : os;
            ob.put(mac, 0, len);
            os -= len;
            iter = (byte)(iter + 1);
        }
        ob.flip();
        byte[] result = new byte[ob.remaining()];
        ob.get(result);
        return result;
    }

    @Override
    public GPKeySet deriveGPKeys(byte version, byte[] keyDiversificationData) {
        byte[] encval = this.deriveData((byte)1, this.keysize, keyDiversificationData);
        byte[] macval = this.deriveData((byte)2, this.keysize, keyDiversificationData);
        byte[] dekval = this.deriveData((byte)3, this.keysize, keyDiversificationData);
        GPKeySet key = new GPKeySet(version, new SecretKeySpec(encval, "AES"), new SecretKeySpec(macval, "AES"), new SecretKeySpec(dekval, "AES"));
        Arrays.fill(encval, (byte)0);
        Arrays.fill(macval, (byte)0);
        Arrays.fill(dekval, (byte)0);
        return key;
    }
}

