/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.pkcs8;

import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.pkcs8.Curve;
import de.cardcontact.opencard.eac.pkcs8.FieldID;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECParameters
extends Sequence {
    public static final ObjectIdentifier ID_ECPUBLICKEY = new ObjectIdentifier(new int[]{1, 2, 840, 10045, 2, 1});
    static final String NAME = "ECParameters";

    public ECParameters(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (this.childs.size() != 5) {
            throw new TLVEncodingException("ECParameters must contain 5 elements");
        }
        if (!(this.childs.get(0) instanceof IntegerTLV)) {
            throw new TLVEncodingException("Version must be INTEGER");
        }
        IntegerTLV itlv = (IntegerTLV)this.childs.get(0);
        if (itlv.getLong() != 1L) {
            throw new TLVEncodingException("Version must be 1");
        }
        this.childs.set(1, new FieldID((TLV)this.childs.get(1)));
        this.childs.set(2, new Curve((TLV)this.childs.get(2)));
        if (!(this.childs.get(3) instanceof OctetString)) {
            throw new TLVEncodingException("Base point must be OCTET-STRING");
        }
        if (!(this.childs.get(4) instanceof IntegerTLV)) {
            throw new TLVEncodingException("Order must be INTEGER");
        }
    }

    public ECParameterSpec getECParameterSpec() {
        ECField field = ((FieldID)this.childs.get(1)).getField();
        EllipticCurve curve = ((Curve)this.childs.get(2)).getCurve(field);
        ECPoint g = ECPublicKeyTLV.decodePoint(((TLV)this.childs.get(3)).getValue());
        BigInteger r = ((IntegerTLV)this.childs.get(4)).getBigInteger();
        return new ECParameterSpec(curve, g, r, 1);
    }
}

